/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.cache;

import com.sprite.utils.cache.Cache;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;

public final class UtilSoftCache<V>
implements Cache<V> {
    private ConcurrentHashMap<String, SoftReference<V>> utilCacheTable = new ConcurrentHashMap();
    private String name;

    private UtilSoftCache(String name) {
        this.name = name;
    }

    @Override
    public void put(String key, V value) {
        this.utilCacheTable.put(key, new SoftReference<V>(value));
    }

    @Override
    public V get(String key) {
        if (key == null) {
            return null;
        }
        SoftReference<V> soft = this.utilCacheTable.get(key);
        if (soft != null) {
            return soft.get();
        }
        return null;
    }

    public static <V> UtilSoftCache<V> createUtilCache(String cacheName) {
        return new UtilSoftCache<V>(cacheName);
    }

    @Override
    public V putIfAbsent(String cacheKey, V v) {
        SoftReference<V> soft = new SoftReference<V>(v);
        if ((soft = this.utilCacheTable.putIfAbsent(cacheKey, soft)) != null) {
            return soft.get();
        }
        return v;
    }

    @Override
    public V remove(String cacheKey) {
        SoftReference<V> soft = this.utilCacheTable.remove(cacheKey);
        if (soft != null) {
            return soft.get();
        }
        return null;
    }

    @Override
    public String getCacheName() {
        return this.name;
    }
}

