/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils;

import com.sprite.utils.UtilCollection;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class UtilXml {
    public static Document readXmlDocument(String content) throws SAXException, ParserConfigurationException, IOException {
        return UtilXml.readXmlDocument(content, true);
    }

    public static Document readXmlDocument(String content, boolean validate) throws SAXException, ParserConfigurationException, IOException {
        if (content == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(content.getBytes("UTF-8"));
        return UtilXml.readXmlDocument(bis, validate, "Internal Content");
    }

    public static Document readXmlDocument(URL url) throws SAXException, ParserConfigurationException, IOException {
        return UtilXml.readXmlDocument(url, true);
    }

    public static Document readXmlDocument(URL url, boolean validate) throws SAXException, ParserConfigurationException, IOException {
        if (url == null) {
            return null;
        }
        InputStream is = url.openStream();
        Document document = UtilXml.readXmlDocument(is, validate, url.toString());
        is.close();
        return document;
    }

    public static Document readXmlDocument(InputStream is, boolean validate, String docDescription) throws ParserConfigurationException, SAXException, IOException {
        if (is == null) {
            return null;
        }
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validate);
        factory.setNamespaceAware(true);
        factory.setAttribute("http://xml.org/sax/features/validation", validate);
        factory.setAttribute("http://apache.org/xml/features/validation/schema", validate);
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (validate) {
            // empty if block
        }
        document = builder.parse(is);
        return document;
    }

    public static List<Element> childElementList(Element element, String childElementName) {
        if (element == null) {
            return null;
        }
        Node node = element.getFirstChild();
        if (node == null) {
            return Collections.emptyList();
        }
        LinkedList<Element> elements = new LinkedList<Element>();
        do {
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (childElementName != null && !childElementName.equals(node.getNodeName())) continue;
            elements.add(childElement);
        } while ((node = node.getNextSibling()) != null);
        return elements;
    }

    public static List<Element> childElementList(Element element) {
        return UtilXml.childElementList(element, null);
    }

    public static Element childElementOne(Element element, String childElementName) {
        List<Element> cList = UtilXml.childElementList(element, childElementName);
        if (UtilCollection.isEmpty(cList)) {
            return null;
        }
        return cList.get(0);
    }

    public static List<Node> childNodeList(Element element) {
        if (element == null) {
            return null;
        }
        Node node = element.getFirstChild();
        if (node == null) {
            return Collections.emptyList();
        }
        LinkedList<Node> elements = new LinkedList<Node>();
        do {
            elements.add(node);
        } while ((node = node.getNextSibling()) != null);
        return elements;
    }

    public static boolean hasChildElement(Element element) {
        if (element == null) {
            return false;
        }
        Node node = element.getFirstChild();
        if (node == null) {
            return false;
        }
        do {
            if (node.getNodeType() != 1) continue;
            return true;
        } while ((node = node.getNextSibling()) != null);
        return false;
    }

    public static Element xpathElementOne(Element element, String xpath) throws Exception {
        List<Element> list = UtilXml.xpathElementList(element, xpath);
        if (UtilCollection.size(list) > 1) {
            throw new Exception("un unique");
        }
        return list.get(0);
    }

    public static List<Element> xpathElementList(Element element, String xpath) throws Exception {
        XPath xPath = XPathFactory.newInstance().newXPath();
        List nodes = (List)xPath.evaluate(xpath, element, XPathConstants.NODESET);
        if (UtilCollection.isEmpty(nodes)) {
            return Collections.emptyList();
        }
        LinkedList<Element> list = new LinkedList<Element>();
        for (Node node : nodes) {
            if (node.getNodeType() != 1) continue;
            list.add((Element)node);
        }
        return list;
    }

    public static Node xpathNodeOne(Element element, String xpath) throws Exception {
        List<Node> list = UtilXml.xpathNodeList(element, xpath);
        if (UtilCollection.size(list) > 1) {
            throw new Exception("un unique");
        }
        return list.get(0);
    }

    public static List<Node> xpathNodeList(Element element, String xpath) throws Exception {
        XPath xPath = XPathFactory.newInstance().newXPath();
        List nodes = (List)xPath.evaluate(xpath, element, XPathConstants.NODESET);
        if (UtilCollection.isEmpty(nodes)) {
            return Collections.emptyList();
        }
        return nodes;
    }

    private UtilXml() {
    }
}

