/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils;

import com.sprite.utils.UtilCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class UtilString {
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private UtilString() {
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !UtilString.isEmpty(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !UtilString.isBlank(cs);
    }

    public static String toString(Object obj) {
        return UtilString.toString(obj, null);
    }

    public static String toString(Object obj, String defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        return String.valueOf(obj);
    }

    public static String[] tokenizeToStringArray(String str, String delimiter) {
        if (delimiter == null) {
            return new String[]{str};
        }
        List<String> result = UtilString.tokenizeToStringList(str, delimiter);
        return result.toArray(new String[result.size()]);
    }

    public static String[] commaDelimiteToStringArray(String str) {
        return UtilString.tokenizeToStringArray(str, ",");
    }

    public static List<String> tokenizeToStringList(String str, String delimiter) {
        int delPos;
        if (str == null) {
            return Collections.emptyList();
        }
        LinkedList<String> result = new LinkedList<String>();
        int delimiterLength = delimiter.length();
        int pos = 0;
        while ((delPos = str.indexOf(delimiter, pos)) != -1) {
            result.add(str.substring(pos, delPos));
            pos = delPos + delimiterLength;
        }
        if (pos < str.length()) {
            result.add(str.substring(pos));
        }
        if (result.isEmpty()) {
            result.add(str);
        }
        return result;
    }

    public static List<String> commaDelimiteToStringList(String str) {
        return UtilString.tokenizeToStringList(str, ",");
    }

    public static String join(Collection<String> strs, String delimiter) {
        StringBuilder stringBuilder = new StringBuilder();
        if (UtilCollection.isNotEmpty(strs)) {
            for (String str : strs) {
                stringBuilder.append(str).append(delimiter);
            }
            stringBuilder.delete(stringBuilder.length() - delimiter.length(), stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    public static String joinToCSV(Collection<String> strs) {
        return UtilString.join(strs, ",");
    }

    public static String place(String str, Object ... params) {
        if (params == null || params.length == 0) {
            return str;
        }
        StringBuilder stringBuilder = new StringBuilder();
        char[] chs = str.toCharArray();
        int pi = 0;
        for (int i = 0; i < chs.length; ++i) {
            if (chs[i] == '{' && chs[i + 1] == '}' && params.length > pi) {
                ++i;
                stringBuilder.append(params[pi++].toString());
                continue;
            }
            stringBuilder.append(chs[i]);
        }
        return stringBuilder.toString();
    }

    public static String byteToHex(byte[] data) {
        if (null == data || data.length <= 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (int n : data) {
            buffer.append(hexChars[(n &= 0xFF) >>> 4]);
            buffer.append(hexChars[n & 0xF]);
        }
        return buffer.toString();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (UtilString.isEmpty(hexString)) {
            return null;
        }
        if (hexString.length() % 2 != 0) {
            throw new IllegalArgumentException("");
        }
        char[] chars = hexString.toCharArray();
        byte[] bts = new byte[hexString.length() / 2];
        for (int i = 0; i < bts.length; ++i) {
            bts[i] = (byte)(UtilString.hexCharToDec(chars[i << 1]) << 4 | UtilString.hexCharToDec(chars[(i << 1) + 1]));
        }
        return bts;
    }

    private static int hexCharToDec(char ch) {
        if (ch <= 'F') {
            return "0123456789ABCDEF".indexOf(ch);
        }
        return "0123456789ABCDEF".indexOf(ch - 35);
    }
}

