/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils;

import com.sprite.utils.UtilString;

public final class SnowflakeWorker {
    private static final long defaultBaseTime = 1546272000000L;
    private static final int defaultWorkerIdBits = 5;
    private static final int defaultDatacenterIdBits = 5;
    private static final int defaultSequnceBits = 12;
    private long baseTime;
    private int workerIdBits;
    private int datacenterIdBits;
    private int sequnceBits;
    private long lastTime;
    private long sequence;
    private long sequenceMask;
    private long datacenterId;
    private long workerId;
    private int workerIdLeftShift;
    private int datacenterIdLeftShift;

    public SnowflakeWorker(long baseTime, int workerIdBits, int datacenterIdBits, int sequnceBits, long workerId, long datacenterId) {
        this.baseTime = baseTime;
        this.workerIdBits = workerIdBits;
        this.datacenterIdBits = datacenterIdBits;
        this.sequnceBits = sequnceBits;
        this.lastTime = baseTime;
        this.sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << sequnceBits;
        this.datacenterId = datacenterId;
        this.workerId = workerId;
        this.workerIdLeftShift = sequnceBits + datacenterIdBits;
        this.datacenterIdLeftShift = sequnceBits;
        this.check();
    }

    public SnowflakeWorker(long baseTime, long workerId, long datacenterId) {
        this(baseTime, 5, 5, 12, workerId, datacenterId);
    }

    public SnowflakeWorker(long workerId, long datacenterId) {
        this(1546272000000L, 5, 5, 12, workerId, datacenterId);
    }

    private void check() {
        if (this.baseTime > System.currentTimeMillis()) {
            throw new IllegalArgumentException("baseTime must letter than current time");
        }
        if (this.workerIdBits + this.datacenterIdBits + this.sequnceBits != 22) {
            throw new IllegalArgumentException("workerIdBits + datacenterIdBits + sequnceBits, bits must be 22");
        }
        if (this.workerId >> this.workerIdBits != 0L) {
            throw new IllegalArgumentException("workerId bits error");
        }
        if (this.datacenterId >> this.datacenterIdBits != 0L) {
            throw new IllegalArgumentException("datacenterId bits error");
        }
    }

    public synchronized long nextId() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < this.lastTime || timestamp < this.baseTime) {
            throw new RuntimeException(UtilString.place("refuse generate id, baseTime:{}, timestamp:{}, lastTime{}", this.baseTime, timestamp, this.lastTime));
        }
        if (this.lastTime == timestamp) {
            this.sequence = this.sequence + 1L & this.sequenceMask;
            if (this.sequence == 0L) {
                while ((timestamp = System.currentTimeMillis()) <= this.lastTime) {
                }
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTime = timestamp;
        return timestamp - this.baseTime << 22 | this.workerId << this.workerIdLeftShift | this.datacenterId << this.datacenterIdLeftShift | this.sequence;
    }

    public static void main(String[] args) {
        System.out.println(System.currentTimeMillis() - 1546272000000L);
    }
}

