/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.util;

import com.sprite.utils.UtilString;

public class SqlUtil {
    public static String DATABASE_TYPE_SQLSERVER = "sqlserver";
    public static String DATABASE_TYPE_SQLSERVER2008 = "sqlserver2008";
    public static String DATABASE_TYPE_SQLSERVER2012 = "sqlserver2012";
    public static String DATABASE_TYPE_MYSQL = "mysql";
    public static String DATABASE_TYPE_ORACLE = "oracle";
    public static String DATABASE_TYPE_PGSQL = "pgsql";

    public static String makeOffset(String sql, int offset, int limit, String dbtype, String orderBy) {
        return SqlUtil.makeOffset(sql, offset, limit, dbtype, orderBy, false);
    }

    public static String makeOffset(String sql, int offset, int limit, String dbtype, String orderBy, boolean hasDistinct) {
        if (DATABASE_TYPE_MYSQL.equals(dbtype)) {
            String temp = "{} LIMIT {},{}";
            return UtilString.place((String)temp, (Object[])new Object[]{sql, offset, limit});
        }
        if (DATABASE_TYPE_SQLSERVER2012.equals(dbtype)) {
            String temp = "{} OFFSET {} ROW FETCH NEXT  {} ROWS only ";
            return UtilString.place((String)temp, (Object[])new Object[]{sql, offset, limit});
        }
        if (DATABASE_TYPE_PGSQL.equals(dbtype)) {
            String temp = "{} LIMIT {} OFFSET {} ";
            return UtilString.place((String)temp, (Object[])new Object[]{sql, limit, offset});
        }
        String tempSql = sql;
        if (DATABASE_TYPE_SQLSERVER2008.equals(dbtype) || DATABASE_TYPE_SQLSERVER.equals(dbtype)) {
            if (UtilString.isBlank((CharSequence)orderBy)) {
                throw new IllegalArgumentException(" orderBy must, if dbtype is  : " + dbtype);
            }
            int index = (sql = sql.trim()).indexOf(32);
            if (index >= 0) {
                sql = sql.substring(index);
            }
            if (hasDistinct && (index = (sql = sql.trim()).indexOf(32)) >= 0) {
                sql = sql.substring(index);
            }
            int fromIndex = -1;
            char[] sqlChars = sql.toCharArray();
            for (int i = 0; i < sqlChars.length - 4; ++i) {
                char nextChar;
                char ch = sqlChars[i];
                if (ch != ' ' || (nextChar = Character.toLowerCase(sqlChars[i + 1])) != 'f' || Character.toLowerCase(sqlChars[i + 2]) != 'r' || Character.toLowerCase(sqlChars[i + 3]) != 'o' || Character.toLowerCase(sqlChars[i + 4]) != 'm') continue;
                fromIndex = i + 1;
                break;
            }
            if (fromIndex < 0) {
                throw new IllegalArgumentException(" sql not contain from : " + tempSql);
            }
            String temp = "SELECT * from (SELECT {} top {} {}, row_number() over({}) as _rnum {}) AS _rn WHERE _rnum>{}";
            return UtilString.place((String)temp, (Object[])new Object[]{hasDistinct ? "DISTINCT" : "", offset + limit, sql.substring(0, fromIndex), orderBy, sql.substring(fromIndex), offset});
        }
        if (DATABASE_TYPE_ORACLE.equals(dbtype)) {
            String temp = "SELECT * FROM(SELECT a.*,ROWNUM _rnum FROM({}) _rn WHERE ROWNUM<=({})) WHERE _rnum>{}";
            return UtilString.place((String)temp, (Object[])new Object[]{sql, offset + limit, offset});
        }
        throw new IllegalArgumentException(" un support dbtype : " + dbtype);
    }

    public static void main(String[] args) {
        String sql = " SELECT  DISTINCT    a.id  AS  id ,   a.name  AS  name  FROM   order_remind_config  AS  a   LEFT JOIN order_remind_config_item  AS  b  ON    a.id   =   b.config_id  ORDER BY  a.id ASC ";
        SqlUtil.makeOffset(sql, 0, 10, "sqlserver2008", "ORDER BY  a.id ASC ", true);
    }
}

