/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.script;

import com.sprite.framework.entity.DataScriptStatement;
import com.sprite.framework.entity.EntityCondition;
import com.sprite.framework.entity.EntityConditionBuilder;
import com.sprite.framework.entity.EntityFindOptions;
import com.sprite.framework.entity.EntityScript;
import com.sprite.framework.entity.script.EntityScriptFunction;
import com.sprite.framework.entity.script.EntityView;

public final class EntitySelectScript
extends EntityConditionBuilder
implements EntityScript {
    private EntityView entityView;
    private String entityAlias = "a";

    public EntitySelectScript(String entityName) {
        this.entityView = new EntityView(entityName, this.entityAlias);
        this.entityView.setWhereCondition(this);
    }

    protected EntitySelectScript() {
    }

    public void distinct() {
        this.entityView.distinct();
    }

    public void addSelectedFieldAs(String ... fields) {
        this.entityView.addViewFieldAs(this.entityAlias, fields);
    }

    public void addSelectedField(String field) {
        this.entityView.addViewField(this.entityAlias, field);
    }

    public void addSelectedField(String ... fields) {
        this.entityView.addViewField(this.entityAlias, fields);
    }

    public void addSelectedField(String field, EntityScriptFunction function) {
        this.entityView.addViewField(this.entityAlias, field, function);
    }

    public void addGroupByField(String field) {
        this.entityView.addGroupByField(this.entityAlias, field);
    }

    public void selectAllField() {
        this.entityView.addViewField(this.entityAlias, new String[0]);
    }

    public void addOrderByDesc(String field) {
        this.entityView.addOrderByDesc(this.entityAlias, field);
    }

    public void addOrderByAsc(String field) {
        this.entityView.addOrderByAsc(this.entityAlias, field);
    }

    public void setWhereCondition(EntityCondition whereCondition) {
        this.whereCondition = EntityCondition.empty().and(whereCondition);
    }

    public void setHavingCondition(EntityCondition havingCondition) {
        this.entityView.setHavingCondition(havingCondition);
    }

    public void setOptions(EntityFindOptions options) {
        this.entityView.setOptions(options);
    }

    public EntityScript countScript(String field) {
        return this.entityView.count(this.entityAlias, field);
    }

    public EntityScript countScript() {
        return this.entityView.countScript();
    }

    @Override
    public DataScriptStatement getStatement() {
        DataScriptStatement statement = new DataScriptStatement();
        this.entityView.makeStatement(statement);
        return statement;
    }
}

