/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.script;

import com.sprite.framework.entity.DataScriptStatement;
import com.sprite.framework.entity.EntityException;
import com.sprite.framework.entity.condition.MultiOperateValue;
import com.sprite.framework.entity.model.ModelEntity;
import com.sprite.framework.entity.model.ModelEntityUtil;
import com.sprite.framework.entity.model.ModelEntityView;
import com.sprite.framework.entity.model.ModelField;
import com.sprite.framework.entity.script.EntityFieldAlias;
import com.sprite.framework.entity.script.EntityFieldAliasBuilder;
import com.sprite.framework.entity.script.EntityScriptFunction;
import java.util.LinkedList;
import java.util.List;

public final class EntityAlias
implements EntityFieldAliasBuilder,
MultiOperateValue {
    private String entityName;
    private String entityAlias;
    private ModelEntity modelEntity;

    protected EntityAlias(String entityName, String entityAlias) {
        this.entityName = entityName;
        this.entityAlias = entityAlias;
        this.modelEntity = ModelEntityUtil.getModelEntity(entityName);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityAlias() {
        return this.entityAlias;
    }

    public ModelEntity getModelEntity() {
        return this.modelEntity;
    }

    @Override
    public EntityFieldAlias buildFieldAlias(String fieldName, String fieldAlias, EntityScriptFunction function) {
        EntityFieldAlias fiAlias = new EntityFieldAlias(this.entityAlias, fieldName, fieldAlias, function, null);
        fiAlias.setModelField(this.modelEntity.getModelField(fieldName));
        return fiAlias;
    }

    @Override
    public List<EntityFieldAlias> buildAllFieldAlias() {
        LinkedList<EntityFieldAlias> list = new LinkedList<EntityFieldAlias>();
        for (ModelField modelField : this.modelEntity.getFields()) {
            list.add(this.buildFieldAlias(modelField.getFieldName(), modelField.getFieldName(), null));
        }
        return list;
    }

    @Override
    public boolean hasField(String field) {
        return this.modelEntity.hasField(field);
    }

    @Override
    public String resolveFieldPath(String path) {
        String entityAlias = null;
        String field = path;
        int i = path.lastIndexOf(".");
        if (i > 0) {
            entityAlias = path.substring(0, i);
            field = path.substring(i + 1);
        }
        if (entityAlias != null) {
            return String.format("%s.%s", entityAlias, this.modelEntity.getModelField(field).getColName());
        }
        return this.modelEntity.getModelField(field).getColName();
    }

    @Override
    public void makeStatement(DataScriptStatement statement, ModelEntityView modelViewEntity) throws EntityException {
        statement.append(this.modelEntity.getTableName());
    }
}

