/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.model;

import com.sprite.framework.entity.EntityException;
import com.sprite.framework.entity.model.ModelEntity;
import com.sprite.framework.entity.model.ModelEntityUtil;
import com.sprite.framework.entity.model.ModelField;
import com.sprite.framework.entity.model.ModelFieldType;
import com.sprite.utils.UtilCollection;
import com.sprite.utils.UtilString;
import com.sprite.utils.UtilXml;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EntityModelReader {
    private Map<String, ModelEntity> modelEntities = new HashMap<String, ModelEntity>();
    private List<ModelEntity> modelExtends = new LinkedList<ModelEntity>();
    private ModelEntity baseEntity = new ModelEntity();
    private ModelEntity sequenceEntity = new ModelEntity();

    public EntityModelReader() {
        this.sequenceEntity.setEntityName("SequenceItem");
        this.sequenceEntity.setTableName(EntityModelReader.addUnderscores("SequenceItem", null));
        this.sequenceEntity.addModelField(new ModelField("sequenceId", "sequence_id", "str-short", true));
        this.sequenceEntity.addModelField(new ModelField("sequenceValue", "sequence_value", "int-long"));
    }

    public void buildModel(Document document) {
        Element docElement = document.getDocumentElement();
        if (!"entity-model".equals(docElement.getTagName())) {
            throw new IllegalArgumentException("entity model error");
        }
        docElement.normalize();
        String defaultPackage = docElement.getAttribute("package");
        List entityList = UtilXml.childElementList((Element)docElement, (String)"entity");
        List baseEntityList = UtilXml.childElementList((Element)docElement, (String)"baseEntity");
        for (Element element : baseEntityList) {
            if (this.baseEntity == null) {
                this.baseEntity = this.buildModelEntity(element, defaultPackage);
                continue;
            }
            this.baseEntity.extend(this.buildModelEntity(element, defaultPackage));
        }
        ModelEntity entity = null;
        for (Element element : entityList) {
            entity = this.buildModelEntity(element, defaultPackage);
            this.modelEntities.put(entity.getEntityName(), entity);
        }
        entityList = UtilXml.childElementList((Element)docElement, (String)"entityExtend");
        for (Element element : entityList) {
            entity = this.buildModelEntity(element, defaultPackage);
            this.modelExtends.add(entity);
        }
    }

    public void buildModelFieldType(Document document, String databaseType) {
        Element docElement = document.getDocumentElement();
        if (!"fieldtype-def".equals(docElement.getTagName())) {
            throw new IllegalArgumentException("entity model field type error");
        }
        List typeList = UtilXml.childElementList((Element)docElement, (String)"type");
        for (Element type : typeList) {
            ModelFieldType fieldType = new ModelFieldType();
            fieldType.setSqlType(type.getAttribute("sqlType"));
            fieldType.setType(type.getAttribute("type"));
            ModelEntityUtil.addModelFieldType(fieldType);
        }
        ModelEntityUtil.setDatabaseType(databaseType);
    }

    private ModelEntity buildModelEntity(Element entity, String defaultPackage) {
        int lastIndex;
        ModelEntity modelEntity = new ModelEntity();
        String packageName = defaultPackage;
        String entityName = entity.getAttribute("entityName");
        String tableName = entity.getAttribute("tableName");
        String singleName = entityName;
        if (UtilString.isNotEmpty((CharSequence)defaultPackage)) {
            entityName = defaultPackage + "." + entityName;
        }
        if ((lastIndex = entityName.lastIndexOf(46)) >= 0) {
            singleName = entityName.substring(lastIndex + 1);
            packageName = entityName.substring(0, lastIndex);
        }
        tableName = EntityModelReader.addUnderscores(tableName, entityName);
        modelEntity.setPackageName(packageName);
        modelEntity.setEntityName(entityName);
        modelEntity.setEntitySingleName(singleName);
        modelEntity.setTableName(tableName);
        List fields = UtilXml.childElementList((Element)entity);
        String filedName = null;
        String colName = null;
        for (Element field : fields) {
            filedName = field.getAttribute("name");
            colName = field.getAttribute("colName");
            colName = EntityModelReader.addUnderscores(colName, filedName);
            ModelField modelField = new ModelField(filedName, colName, field.getAttribute("type"));
            modelField.setKey("key".equals(field.getTagName()));
            modelEntity.addModelField(modelField);
        }
        return modelEntity;
    }

    public void merge() {
        boolean hasSequenceId = false;
        for (ModelEntity modelEntity : this.modelEntities.values()) {
            List<ModelField> keys = modelEntity.getKeys();
            if (UtilCollection.isEmpty(keys)) continue;
            for (ModelField keyField : keys) {
                if (!"sequence".equals(keyField.getType())) continue;
                hasSequenceId = true;
                break;
            }
            if (!hasSequenceId) continue;
            break;
        }
        if (hasSequenceId) {
            this.sequenceEntity.extend(this.baseEntity);
            ModelEntityUtil.addModelEntity(this.sequenceEntity);
        }
        for (ModelEntity extend : this.modelExtends) {
            ModelEntity modelEntity = this.modelEntities.get(extend.getEntityName());
            if (modelEntity == null) {
                throw new EntityException("not found modeEntity: " + extend.getEntityName());
            }
            modelEntity.extend(extend);
        }
        for (ModelEntity modelEntity : this.modelEntities.values()) {
            modelEntity.extend(this.baseEntity);
        }
        ModelEntityUtil.addModelEntities(this.modelEntities.values());
    }

    protected static String addUnderscores(String name, String defaultValue) {
        if (UtilString.isEmpty((CharSequence)name)) {
            name = defaultValue;
        }
        StringBuilder buf = new StringBuilder();
        char[] chars = name.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '.') {
                if (i <= 0 || chars[i - 1] == '.') continue;
                buf.append("_");
                continue;
            }
            if (i > 0 && Character.isUpperCase(chars[i]) && chars[i - 1] != '.') {
                buf.append("_");
            }
            buf.append(chars[i]);
        }
        return buf.toString().toLowerCase();
    }
}

