/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.mapper.reolver;

import com.sprite.framework.entity.mapper.MapperException;
import com.sprite.utils.cache.UtilSoftCache;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;

public final class OgnlUtils {
    private static UtilSoftCache<Object> _cahce = UtilSoftCache.createUtilCache((String)"");
    private static DefaultMemberAccess memberAccess = new DefaultMemberAccess(true);

    private static Object pressExpression(String expression) throws OgnlException {
        Object object = _cahce.get(expression);
        if (object != null) {
            return object;
        }
        object = Ognl.parseExpression((String)expression);
        _cahce.put(expression, object);
        return object;
    }

    public static Object evaluateObject(String expression, Object parameterObject) {
        try {
            Object prs = OgnlUtils.pressExpression(expression);
            Object value = Ognl.getValue((Object)prs, (Map)new OgnlContext(null, null, (MemberAccess)memberAccess), (Object)parameterObject);
            return value;
        }
        catch (Exception e) {
            throw new MapperException(e);
        }
    }

    public static boolean evaluateBoolean(String expression, Object parameterObject) {
        Object value = OgnlUtils.evaluateObject(expression, parameterObject);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return !new BigDecimal(String.valueOf(value)).equals(BigDecimal.ZERO);
        }
        return value != null;
    }

    public static Iterable<?> evaluateIterable(String expression, Object parameterObject) {
        Object value = OgnlUtils.evaluateObject(expression, parameterObject);
        if (value == null) {
            throw new MapperException("The expression '" + expression + "' evaluated to a null value.");
        }
        if (value instanceof Iterable) {
            return (Iterable)value;
        }
        if (value.getClass().isArray()) {
            int size = Array.getLength(value);
            ArrayList<Object> answer = new ArrayList<Object>();
            for (int i = 0; i < size; ++i) {
                Object o = Array.get(value, i);
                answer.add(o);
            }
            return answer;
        }
        if (value instanceof Map) {
            return ((Map)value).entrySet();
        }
        throw new MapperException("Error evaluating expression '" + expression + "'.  Return value (" + value + ") was not iterable.");
    }

    public static class DefaultMemberAccess
    implements MemberAccess {
        public boolean allowPrivateAccess = false;
        public boolean allowProtectedAccess = false;
        public boolean allowPackageProtectedAccess = false;

        public DefaultMemberAccess(boolean allowAllAccess) {
            this(allowAllAccess, allowAllAccess, allowAllAccess);
        }

        public DefaultMemberAccess(boolean allowPrivateAccess, boolean allowProtectedAccess, boolean allowPackageProtectedAccess) {
            this.allowPrivateAccess = allowPrivateAccess;
            this.allowProtectedAccess = allowProtectedAccess;
            this.allowPackageProtectedAccess = allowPackageProtectedAccess;
        }

        public boolean getAllowPrivateAccess() {
            return this.allowPrivateAccess;
        }

        public void setAllowPrivateAccess(boolean value) {
            this.allowPrivateAccess = value;
        }

        public boolean getAllowProtectedAccess() {
            return this.allowProtectedAccess;
        }

        public void setAllowProtectedAccess(boolean value) {
            this.allowProtectedAccess = value;
        }

        public boolean getAllowPackageProtectedAccess() {
            return this.allowPackageProtectedAccess;
        }

        public void setAllowPackageProtectedAccess(boolean value) {
            this.allowPackageProtectedAccess = value;
        }

        public Object setup(Map context, Object target, Member member, String propertyName) {
            AccessibleObject accessible;
            Boolean result = null;
            if (this.isAccessible(context, target, member, propertyName) && !(accessible = (AccessibleObject)((Object)member)).isAccessible()) {
                result = Boolean.FALSE;
                accessible.setAccessible(true);
            }
            return result;
        }

        public void restore(Map context, Object target, Member member, String propertyName, Object state) {
            if (state != null) {
                AccessibleObject accessible = (AccessibleObject)((Object)member);
                boolean stateboolean = (Boolean)state;
                if (!stateboolean) {
                    accessible.setAccessible(stateboolean);
                } else {
                    throw new IllegalArgumentException("Improper restore state [" + stateboolean + "] for target [" + target + "], member [" + member + "], propertyName [" + propertyName + "]");
                }
            }
        }

        public boolean isAccessible(Map context, Object target, Member member, String propertyName) {
            int modifiers = member.getModifiers();
            boolean result = Modifier.isPublic(modifiers);
            if (!result) {
                result = Modifier.isPrivate(modifiers) ? this.getAllowPrivateAccess() : (Modifier.isProtected(modifiers) ? this.getAllowProtectedAccess() : this.getAllowPackageProtectedAccess());
            }
            return result;
        }
    }
}

