/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.ddl;

import com.sprite.framework.entity.ddl.ColumnMetadata;
import com.sprite.framework.entity.ddl.ForeignKeyMetadata;
import com.sprite.framework.entity.ddl.IndexMetadata;
import com.sprite.utils.UtilString;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

public class TableMetadata {
    private String catalog;
    private String schema;
    private String name;
    private Map<String, ColumnMetadata> columnMetadataMap = new LinkedHashMap<String, ColumnMetadata>();
    private Map<String, ForeignKeyMetadata> foreignKeyMetadataMap = new LinkedHashMap<String, ForeignKeyMetadata>();
    private Map<String, IndexMetadata> indexMetadataMap = new LinkedHashMap<String, IndexMetadata>();

    public TableMetadata(ResultSet rs, DatabaseMetaData meta) throws SQLException {
        this.catalog = rs.getString("TABLE_CAT");
        this.schema = rs.getString("TABLE_SCHEM");
        this.name = rs.getString("TABLE_NAME");
        this.initColumns(meta);
        this.initForeignKeys(meta);
        this.initIndexes(meta);
    }

    public String identify() {
        return TableMetadata.tableIdentify(this.catalog, this.schema, this.name);
    }

    public ColumnMetadata getColumnMetadata(String columnName) {
        return this.columnMetadataMap.get(columnName.toLowerCase());
    }

    public ForeignKeyMetadata getForeignKeyMetadata(String keyName) {
        return this.foreignKeyMetadataMap.get(keyName.toLowerCase());
    }

    public IndexMetadata getIndexMetadata(String indexName) {
        return this.indexMetadataMap.get(indexName.toLowerCase());
    }

    private void initColumns(DatabaseMetaData meta) throws SQLException {
        try (ResultSet rs = null;){
            rs = meta.getColumns(this.catalog, this.schema, this.name, "%");
            while (rs.next()) {
                this.addColumn(rs);
            }
        }
    }

    private void initForeignKeys(DatabaseMetaData meta) throws SQLException {
        try (ResultSet rs = null;){
            rs = meta.getImportedKeys(this.catalog, this.schema, this.name);
            while (rs.next()) {
                this.addForeignKey(rs);
            }
        }
    }

    private void initIndexes(DatabaseMetaData meta) throws SQLException {
        try (ResultSet rs = null;){
            rs = meta.getIndexInfo(this.catalog, this.schema, this.name, false, true);
            while (rs.next()) {
                if (rs.getShort("TYPE") == 0) continue;
                this.addIndex(rs);
            }
        }
    }

    public void addColumn(ResultSet rs) throws SQLException {
        ColumnMetadata info = new ColumnMetadata(rs);
        if (this.getColumnMetadata(info.getName()) == null) {
            this.columnMetadataMap.put(info.getName().toLowerCase(), info);
        }
    }

    private void addForeignKey(ResultSet rs) throws SQLException {
        ForeignKeyMetadata info = new ForeignKeyMetadata(rs);
        if (this.getForeignKeyMetadata(info.getName()) != null) {
            this.foreignKeyMetadataMap.put(info.getName().toLowerCase(), info);
        }
    }

    private void addIndex(ResultSet rs) throws SQLException {
        IndexMetadata info = new IndexMetadata(rs);
        if (this.getIndexMetadata(info.getName()) != null) {
            this.indexMetadataMap.put(info.getName().toLowerCase(), info);
        }
    }

    public static String tableIdentify(String catalog, String schema, String table) {
        StringBuilder stringBuilder = new StringBuilder();
        if (UtilString.isNotEmpty((CharSequence)catalog)) {
            stringBuilder.append(catalog).append(".");
        }
        if (UtilString.isNotEmpty((CharSequence)schema)) {
            stringBuilder.append(schema).append(".");
        }
        stringBuilder.append(table);
        return stringBuilder.toString();
    }
}

