/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity;

import com.sprite.framework.entity.model.ModelEntityUtil;
import com.sprite.framework.entity.model.ModelField;
import com.sprite.framework.entity.util.EntityUtil;
import com.sprite.utils.UtilBeans;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class EntityObject
extends LinkedHashMap<String, Object> {
    private String entityName;

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void set(String prop, Object value) {
        super.put(prop, value);
    }

    public Integer getInteger(String prop) {
        return EntityUtil.convert(this.get(prop), Integer.class);
    }

    public int getInteger(String prop, int defaultValue) {
        Integer value = this.getInteger(prop);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Long getLong(String prop) {
        return EntityUtil.convert(this.get(prop), Long.class);
    }

    public Date getDate(String prop) {
        return EntityUtil.convert(this.get(prop), Date.class);
    }

    public BigDecimal getBigDecimal(String prop) {
        return EntityUtil.convert(this.get(prop), BigDecimal.class);
    }

    public String getString(String prop) {
        return EntityUtil.convert(this.get(prop), String.class);
    }

    public Boolean getBoolean(String prop) {
        return EntityUtil.convert(this.get(prop), Boolean.class);
    }

    public BigInteger getBigInteger(String prop) {
        return EntityUtil.convert(this.get(prop), BigInteger.class);
    }

    public Double getDouble(String prop) {
        return EntityUtil.convert(this.get(prop), Double.class);
    }

    public static EntityObject map(String entityName, Object object) {
        EntityObject entityObject = new EntityObject();
        Map values = UtilBeans.toMap((Object)object);
        for (ModelField field : ModelEntityUtil.getModelEntity(entityName).getFields()) {
            Object value = values.get(field.getFieldName());
            if (value == null) continue;
            entityObject.put(field.getFieldName(), value);
        }
        return entityObject;
    }
}

