/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.util;

import com.sprite.framework.entity.DataScriptStatement;
import com.sprite.framework.entity.EntityScript;
import com.sprite.framework.entity.EntityScriptExecutor;
import com.sprite.framework.entity.ddl.ColumnMetadata;
import com.sprite.framework.entity.ddl.DatabaseMetadata;
import com.sprite.framework.entity.ddl.TableMetadata;
import com.sprite.framework.entity.model.ModelEntity;
import com.sprite.framework.entity.model.ModelEntityUtil;
import com.sprite.framework.entity.model.ModelField;
import com.sprite.framework.entity.util.OrmConfig;
import com.sprite.utils.UtilMisc;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseUtil {
    private static Logger logger = LoggerFactory.getLogger(DatabaseUtil.class);
    private DataSource dataSource;
    private EntityScriptExecutor scriptExecutor;

    private String getCatalog(Connection connection, String defaultCatalog) {
        try {
            String catalog = connection.getCatalog();
            if (catalog != null) {
                return catalog;
            }
        }
        catch (Exception e) {
            logger.warn("[getCatalog] {}", (Object)e.getMessage());
        }
        return defaultCatalog;
    }

    private String getSchema(Connection connection, String defaultSchema) {
        try {
            String schema = connection.getSchema();
            if (schema != null) {
                return schema;
            }
        }
        catch (Exception e) {
            logger.warn("[getSchema] {}", (Object)e.getMessage());
        }
        return defaultSchema;
    }

    public void checkDb(List<ModelEntity> entityList, OrmConfig ormConfig) throws SQLException {
        Connection connection = this.dataSource.getConnection();
        String connCatalog = this.getCatalog(connection, ormConfig.getDefaultCatalog());
        String connSchema = this.getSchema(connection, ormConfig.getDefaultSchema());
        DatabaseMetadata databaseMetadata = new DatabaseMetadata(connection);
        LinkedList<ModelEntity> listToCreate = new LinkedList<ModelEntity>();
        LinkedList<ColumnCheckInfo> listToadd = new LinkedList<ColumnCheckInfo>();
        for (ModelEntity modelEntity : entityList) {
            String schema;
            String catalog;
            String tableName = modelEntity.getTableName().toLowerCase();
            TableMetadata tableMetadata = databaseMetadata.getTableMetadata(tableName, catalog = connCatalog, schema = connSchema);
            if (tableMetadata == null) {
                listToCreate.add(modelEntity);
                continue;
            }
            for (ModelField modelField : modelEntity.getFields()) {
                ColumnMetadata columnMetadata = tableMetadata.getColumnMetadata(modelField.getColName());
                if (columnMetadata != null) continue;
                ColumnCheckInfo columnCheckInfo = new ColumnCheckInfo(tableName, modelField.getColName(), modelField.getType());
                columnCheckInfo.setCatalog(catalog);
                columnCheckInfo.setSchema(schema);
                listToadd.add(columnCheckInfo);
            }
        }
        for (ModelEntity modelEntity : listToCreate) {
            this.scriptExecutor.execute(new CreateTableScript(modelEntity));
            logger.info("create table :{}", (Object)modelEntity.getTableName());
        }
        for (ColumnCheckInfo columnCheckInfo : listToadd) {
            this.scriptExecutor.execute(new AddColumnScript(columnCheckInfo));
            logger.info("add column :{}, table:{} ", (Object)columnCheckInfo.columnName, (Object)columnCheckInfo.tableName);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public EntityScriptExecutor getScriptExecutor() {
        return this.scriptExecutor;
    }

    public void setScriptExecutor(EntityScriptExecutor scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    private static class AddColumnScript
    implements EntityScript {
        List<ColumnCheckInfo> columnList;

        public AddColumnScript(ColumnCheckInfo columnList) {
            this.columnList = UtilMisc.toList((Object)columnList);
        }

        @Override
        public DataScriptStatement getStatement() {
            DataScriptStatement scriptStatement = new DataScriptStatement();
            for (ColumnCheckInfo column : this.columnList) {
                scriptStatement.append("ALTER  TABLE ").append(column.tableName).append(" ADD ").append(column.columnName);
                scriptStatement.append(" ").append(ModelEntityUtil.getFieldType(column.type).getSqlType()).append(";");
            }
            return scriptStatement;
        }
    }

    private static class CreateTableScript
    implements EntityScript {
        List<ModelEntity> entityList;

        public CreateTableScript(ModelEntity modelEntity) {
            this.entityList = UtilMisc.toList((Object)modelEntity);
        }

        @Override
        public DataScriptStatement getStatement() {
            DataScriptStatement scriptStatement = new DataScriptStatement();
            for (ModelEntity entity : this.entityList) {
                scriptStatement.append("CREATE TABLE ").append(entity.getTableName()).append("(");
                List<ModelField> fields = entity.getFields();
                int lg = fields.size();
                for (ModelField modelField : fields) {
                    scriptStatement.append(modelField.getColName()).append(" ").append(ModelEntityUtil.getFieldType(modelField.getType()).getSqlType());
                    if (lg > 1) {
                        scriptStatement.append(",");
                    }
                    --lg;
                }
                if (!entity.getKeys().isEmpty()) {
                    scriptStatement.append(",PRIMARY KEY(");
                    lg = entity.getKeys().size();
                    for (ModelField modelField : entity.getKeys()) {
                        scriptStatement.append(modelField.getColName());
                        if (lg > 1) {
                            scriptStatement.append(",");
                        }
                        --lg;
                    }
                    scriptStatement.append(")");
                }
                scriptStatement.append(");");
            }
            return scriptStatement;
        }
    }

    private static class ColumnCheckInfo {
        public String catalog;
        public String schema;
        public String tableName;
        public String columnName;
        public String type;

        public ColumnCheckInfo(String tableName, String columnName, String type) {
            this.tableName = tableName;
            this.columnName = columnName;
            this.type = type;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        public String getSchema() {
            return this.schema;
        }

        public void setSchema(String schema) {
            this.schema = schema;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

