/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.support.spring;

import com.sprite.framework.component.SpriteConfig;
import com.sprite.framework.component.SpriteConfigLoader;
import com.sprite.framework.entity.EntityLoader;
import com.sprite.framework.entity.EntityScriptExecutor;
import com.sprite.framework.entity.config.EntityResourceInfo;
import com.sprite.framework.entity.support.spring.event.SpriteOrmLoadFinishedEvent;
import com.sprite.framework.entity.util.OrmConfig;
import com.sprite.utils.UtilCollection;
import com.sprite.utils.UtilString;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class SpriteOrmLoader
implements ApplicationListener<ContextRefreshedEvent> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile boolean inited = false;
    @Autowired
    private EntityScriptExecutor entityScriptExecutor;
    @Autowired
    private OrmConfig ormConfig;
    @Autowired
    private SpriteConfigLoader spriteConfigLoader;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.inited) {
            return;
        }
        OrmConfig.setConfig(this.ormConfig);
        this.initOrm();
        this.inited = true;
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SpriteOrmLoadFinishedEvent((ApplicationContext)event.getSource()));
    }

    private void initOrm() {
        if (this.entityScriptExecutor == null) {
            throw new RuntimeException("not found entityScriptExecutor");
        }
        String sqlType = this.ormConfig.getSqlType();
        boolean ddlauto = this.ormConfig.isDdlAuto();
        if (UtilString.isBlank((CharSequence)sqlType)) {
            throw new RuntimeException("not specified sql type ");
        }
        try {
            List componentConfigs = this.spriteConfigLoader.getAllComponents();
            if (UtilCollection.isEmpty((Collection)componentConfigs)) {
                this.logger.info("[initOrm] not found sprite.xml");
                return;
            }
            LinkedList<EntityResourceInfo> resourceInfos = new LinkedList<EntityResourceInfo>();
            for (SpriteConfig spriteConfig : componentConfigs) {
                resourceInfos.addAll(EntityResourceInfo.resolveResourceInfo(this.spriteConfigLoader.getSpriteConfigElement(spriteConfig), spriteConfig));
            }
            EntityLoader entityLoader = new EntityLoader();
            entityLoader.setEntityResourceInfoList(resourceInfos);
            entityLoader.setEntityScriptExecutor(this.entityScriptExecutor);
            entityLoader.setOrmConfig(this.ormConfig);
            entityLoader.loadEntityModel(ddlauto);
            entityLoader.loadEntityData();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

