/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.support.spring;

import com.sprite.framework.context.ContextEnvironment;
import com.sprite.framework.entity.Delegator;
import com.sprite.framework.entity.EntityInterceptor;
import com.sprite.framework.entity.EntityScriptExecutor;
import com.sprite.framework.entity.GenericDelegator;
import com.sprite.framework.entity.IdGenerator;
import com.sprite.framework.entity.bridge.JdbcTemplateBridge;
import com.sprite.framework.entity.mapper.DefaultStatementDelegator;
import com.sprite.framework.entity.mapper.StatementDelegator;
import com.sprite.framework.entity.support.spring.SpriteOrmLoader;
import com.sprite.framework.entity.util.OrmConfig;
import com.sprite.utils.UtilString;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class SpriteOrmConfiguration
implements InitializingBean {
    @Autowired(required=false)
    private EntityInterceptor entityInterceptor;
    @Autowired
    private EntityScriptExecutor entityScriptExecutor;
    @Autowired(required=false)
    private List<IdGenerator> generatorList;
    @Value(value="${sprite.orm.sqltype:}")
    private String ormSqlType;
    @Value(value="${sprite.orm.ddlauto:}")
    private Boolean ormDdlauto;
    @Value(value="${sprite.orm.catalog:#{null}}")
    private String ormCatalog;
    @Value(value="${sprite.orm.schema:#{null}}")
    private String ormSchema;
    @Value(value="${sprite.orm.sqllog:}")
    private Boolean sqllog;
    @Value(value="${sprite.orm.cached-mapper:}")
    private Boolean cachedMapper;

    @Bean
    public Delegator delegator() {
        GenericDelegator delegator = new GenericDelegator();
        delegator.setEntityInterceptor(this.entityInterceptor);
        delegator.addGenerator(this.generatorList);
        delegator.setScriptExecutor(this.entityScriptExecutor);
        return delegator;
    }

    @Bean
    public EntityScriptExecutor scriptExecutor(DataSource dataSource) {
        JdbcTemplateBridge jdbcTemplateBridge = new JdbcTemplateBridge();
        JdbcTemplate jdbcTemplate = new JdbcTemplate();
        jdbcTemplate.setDataSource(dataSource);
        jdbcTemplateBridge.setJdbcTemplate(jdbcTemplate);
        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager();
        dataSourceTransactionManager.setDataSource(dataSource);
        jdbcTemplateBridge.setPlatformTransactionManager((PlatformTransactionManager)dataSourceTransactionManager);
        return jdbcTemplateBridge;
    }

    @Bean
    public StatementDelegator statementDelegator() {
        return new DefaultStatementDelegator();
    }

    @Bean
    public SpriteOrmLoader spriteOrmLoader() {
        return new SpriteOrmLoader();
    }

    @Bean
    public OrmConfig ormConfig() {
        OrmConfig ormConfig = new OrmConfig();
        ormConfig.setCachedMapper(this.cachedMapper);
        ormConfig.setDdlAuto(this.ormDdlauto);
        ormConfig.setSqlType(this.ormSqlType);
        ormConfig.setOpenLog(this.sqllog);
        ormConfig.setDefaultCatalog(this.ormCatalog);
        ormConfig.setDefaultSchema(this.ormSchema);
        return ormConfig;
    }

    public void afterPropertiesSet() throws Exception {
        if (UtilString.isEmpty((CharSequence)this.ormSqlType)) {
            this.ormSqlType = ContextEnvironment.getProperty((String)"sprite.orm.sqltype");
        }
        if (this.ormDdlauto == null) {
            this.ormDdlauto = "true".equalsIgnoreCase(ContextEnvironment.getProperty((String)"sprite.orm.ddlauto", (String)"true"));
        }
        if (this.sqllog == null) {
            this.sqllog = "true".equalsIgnoreCase(ContextEnvironment.getProperty((String)"sprite.orm.sqllog", (String)"false"));
        }
        if (this.cachedMapper == null) {
            this.cachedMapper = "true".equalsIgnoreCase(ContextEnvironment.getProperty((String)"sprite.orm.cached-mapper", (String)"true"));
        }
    }
}

