/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.script;

import com.sprite.framework.entity.DataScriptStatement;
import com.sprite.framework.entity.EntityException;
import com.sprite.framework.entity.EntityScript;
import com.sprite.framework.entity.model.ModelEntity;
import com.sprite.framework.entity.model.ModelEntityUtil;
import com.sprite.framework.entity.model.ModelEntityView;
import com.sprite.utils.UtilString;
import java.util.HashMap;
import java.util.Map;

public final class EntityInsertScript
implements EntityScript {
    private String entityName;
    private Map<String, Object> fieldsToUpdate = new HashMap<String, Object>();
    private Map<String, Object> generatedKey = new HashMap<String, Object>();

    public EntityInsertScript(String entityName) {
        this.entityName = entityName;
    }

    protected EntityInsertScript() {
    }

    public void makeStatement(DataScriptStatement statement, ModelEntityView modelViewEntity) throws EntityException {
        this.initModelViewEntity(modelViewEntity);
        ModelEntity modelEntity = ModelEntityUtil.getModelEntity(this.entityName);
        statement.append(UtilString.place((String)"INSERT INTO {}(", (Object[])new Object[]{modelEntity.getTableName()}));
        int lg = this.fieldsToUpdate.size();
        for (Map.Entry<String, Object> entry : this.fieldsToUpdate.entrySet()) {
            statement.addParam(entry.getValue());
            statement.append(modelEntity.getModelField(entry.getKey()).getColName());
            if (lg > 1) {
                statement.append(",");
            } else {
                statement.append(")");
            }
            --lg;
        }
        statement.append(" VALUES(");
        for (lg = this.fieldsToUpdate.size(); lg > 0; --lg) {
            if (lg > 1) {
                statement.append("?,");
                continue;
            }
            statement.append("?)");
        }
    }

    public void addFields(Map<String, Object> fields) {
        this.fieldsToUpdate.putAll(fields);
    }

    private void initModelViewEntity(ModelEntityView modelViewEntity) throws EntityException {
        if (modelViewEntity == null) {
            return;
        }
    }

    public Map<String, Object> getGeneratedKey() {
        return this.generatedKey;
    }

    public void addGeneratedKey(String prop, Object value) {
        this.generatedKey.put(prop, value);
    }

    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public DataScriptStatement getStatement() {
        DataScriptStatement statement = new DataScriptStatement();
        this.makeStatement(statement, null);
        return statement;
    }
}

