/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.ddl;

import com.sprite.framework.entity.ddl.TableMetadata;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class DatabaseMetadata {
    private Map<String, TableMetadata> tableMetadataMap = new HashMap<String, TableMetadata>();
    private DatabaseMetaData meta;
    private final String[] types = new String[]{"TABLE", "VIEW"};

    public DatabaseMetadata(Connection connection) throws SQLException {
        this.meta = connection.getMetaData();
    }

    public TableMetadata getTableMetadata(String name, String catalog, String schema) throws SQLException {
        String identifer = TableMetadata.tableIdentify(catalog, schema, name);
        TableMetadata metadata = this.tableMetadataMap.get(identifer);
        if (metadata == null) {
            this.initTableMetadata(name, catalog, schema);
            metadata = this.tableMetadataMap.get(identifer);
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTableMetadata(String name, String catalog, String schema) throws SQLException {
        try (ResultSet resultSet = this.meta.getTables(catalog, schema, name, this.types);){
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                if (!name.equalsIgnoreCase(tableName)) continue;
                TableMetadata tableMetadata = new TableMetadata(resultSet, this.meta);
                this.tableMetadataMap.put(tableMetadata.identify(), tableMetadata);
            }
        }
    }
}

