/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.config;

import com.sprite.framework.component.SpriteConfig;
import com.sprite.framework.config.ResourceInfo;
import com.sprite.utils.UtilXml;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EntityResourceInfo
extends ResourceInfo {
    private String resourceType;
    private String name;

    public static List<EntityResourceInfo> resolveResourceInfo(List<Element> elements, SpriteConfig spriteConfig) {
        LinkedList<EntityResourceInfo> list = new LinkedList<EntityResourceInfo>();
        for (Element element : elements) {
            if (!"entity-resource".equals(element.getTagName())) continue;
            String type = element.getAttribute("type");
            String location = spriteConfig.relativeResource(element.getAttribute("location")).toString();
            EntityResourceInfo resourceInfo = new EntityResourceInfo(location, type);
            resourceInfo.setName(element.getAttribute("name"));
            list.add(resourceInfo);
        }
        return list;
    }

    public EntityResourceInfo(String location, String resourceType) {
        this.location = location;
        this.resourceType = resourceType;
    }

    public Document getDocument() throws Exception {
        return UtilXml.readXmlDocument((InputStream)this.getStream(), (boolean)false, null);
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

