/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.bridge;

import com.sprite.framework.entity.transaction.TransactionExecutor;
import com.sprite.framework.entity.transaction.TransactionScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class SpringTransactionScript
implements TransactionScript {
    private static Logger logger = LoggerFactory.getLogger(SpringTransactionScript.class);
    private TransactionStatus transactionStatus;
    private PlatformTransactionManager platformTransactionManager;

    protected SpringTransactionScript(PlatformTransactionManager transactionManager) {
        this.platformTransactionManager = transactionManager;
    }

    @Override
    public void begin() {
        if (this.transactionStatus != null) {
            throw new UnsupportedOperationException(" has begin");
        }
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setIsolationLevel(8);
        definition.setPropagationBehavior(3);
        this.transactionStatus = this.platformTransactionManager.getTransaction((TransactionDefinition)definition);
    }

    @Override
    public void rollback() {
        this.platformTransactionManager.rollback(this.transactionStatus);
    }

    @Override
    public void commit() {
        this.platformTransactionManager.commit(this.transactionStatus);
    }

    @Override
    public void execute(TransactionExecutor executor) {
        if (this.transactionStatus == null) {
            this.begin();
        }
        try {
            executor.execute();
            this.commit();
        }
        catch (Exception e) {
            this.rollback();
            logger.error("[execute] execute error", (Throwable)e);
        }
    }

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public PlatformTransactionManager getPlatformTransactionManager() {
        return this.platformTransactionManager;
    }

    public void setPlatformTransactionManager(PlatformTransactionManager platformTransactionManager) {
        this.platformTransactionManager = platformTransactionManager;
    }
}

