/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.bridge;

import com.sprite.framework.entity.DataScriptStatement;
import com.sprite.framework.entity.EntityScript;
import com.sprite.framework.entity.EntityScriptExecutor;
import com.sprite.framework.entity.bridge.RowToObjectMapper;
import com.sprite.framework.entity.bridge.SpringTransactionScript;
import com.sprite.framework.entity.model.ModelEntity;
import com.sprite.framework.entity.model.ModelEntityUtil;
import com.sprite.framework.entity.model.ModelField;
import com.sprite.framework.entity.script.EntityInsertScript;
import com.sprite.framework.entity.transaction.TransactionScript;
import com.sprite.framework.entity.util.DatabaseUtil;
import com.sprite.framework.entity.util.SqlLogUtil;
import com.sprite.utils.UtilCollection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.transaction.PlatformTransactionManager;

public class JdbcTemplateBridge
implements EntityScriptExecutor {
    private JdbcTemplate jdbcTemplate;
    private PlatformTransactionManager platformTransactionManager;

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public PlatformTransactionManager getPlatformTransactionManager() {
        return this.platformTransactionManager;
    }

    public void setPlatformTransactionManager(PlatformTransactionManager platformTransactionManager) {
        this.platformTransactionManager = platformTransactionManager;
    }

    @Override
    public int execute(final EntityScript script) {
        final DataScriptStatement dataScript = script.getStatement();
        final String sql = dataScript.toScriptString();
        if (SqlLogUtil.openLog()) {
            SqlLogUtil.log(sql);
            SqlLogUtil.log(Arrays.toString(dataScript.getParams().toArray()));
        }
        return (Integer)this.jdbcTemplate.execute(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                EntityInsertScript insertScript;
                ModelEntity modelEntity;
                ModelField modelField;
                if (EntityInsertScript.class.isInstance(script) && (modelField = (ModelField)UtilCollection.at((modelEntity = ModelEntityUtil.getModelEntity((insertScript = (EntityInsertScript)script).getEntityName())).getKeys(), (int)0)) != null && "identify".equals(modelField.getType())) {
                    return con.prepareStatement(sql, 1);
                }
                return con.prepareStatement(sql);
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<Integer>(){

            public Integer doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                ResultSet keys;
                EntityInsertScript insertScript;
                ModelEntity modelEntity;
                ModelField modelField;
                List<Object> params = dataScript.getParams();
                JdbcTemplateBridge.this.setParams(ps, params);
                int result = ps.executeUpdate();
                if (EntityInsertScript.class.isInstance(script) && (modelField = (ModelField)UtilCollection.at((modelEntity = ModelEntityUtil.getModelEntity((insertScript = (EntityInsertScript)script).getEntityName())).getKeys(), (int)0)) != null && "identify".equals(modelField.getType()) && (keys = ps.getGeneratedKeys()).next()) {
                    Object keyValue = keys.getObject(1);
                    insertScript.addGeneratedKey(modelField.getFieldName(), keyValue);
                }
                return result;
            }
        });
    }

    @Override
    public <T> List<T> query(EntityScript script, Class<T> clazz) {
        DataScriptStatement statement = script.getStatement();
        String sql = statement.toScriptString();
        Object[] params = statement.getParams().toArray();
        if (SqlLogUtil.openLog()) {
            SqlLogUtil.log(sql);
            SqlLogUtil.log(Arrays.toString(params));
        }
        return this.jdbcTemplate.query(sql, new RowToObjectMapper<T>(clazz), params);
    }

    private void setParams(PreparedStatement ps, List<Object> params) throws SQLException {
        int i = 1;
        for (Object param : params) {
            ps.setObject(i++, param);
        }
    }

    @Override
    public TransactionScript beginTransaction(boolean create) {
        SpringTransactionScript script = new SpringTransactionScript(this.platformTransactionManager);
        return script;
    }

    @Override
    public DatabaseUtil getDatabaseUtil() {
        DatabaseUtil util = new DatabaseUtil();
        util.setDataSource(this.jdbcTemplate.getDataSource());
        util.setScriptExecutor(this);
        return util;
    }
}

