/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity;

import com.sprite.framework.common.Assert;
import com.sprite.framework.entity.EntityObject;
import com.sprite.framework.entity.EntityScriptExecutor;
import com.sprite.framework.entity.config.EntityResourceInfo;
import com.sprite.framework.entity.model.EntityModelReader;
import com.sprite.framework.entity.model.ModelEntityUtil;
import com.sprite.framework.entity.script.EntityInsertScript;
import com.sprite.framework.entity.transaction.TransactionExecutor;
import com.sprite.framework.entity.transaction.TransactionScript;
import com.sprite.framework.entity.util.EntityDataReader;
import com.sprite.framework.entity.util.EntityGroup;
import com.sprite.framework.entity.util.OrmConfig;
import com.sprite.utils.UtilCollection;
import com.sprite.utils.UtilString;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityLoader {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private EntityScriptExecutor entityScriptExecutor;
    private OrmConfig ormConfig;
    private List<EntityResourceInfo> entityResourceInfoList = new LinkedList<EntityResourceInfo>();

    private List<EntityResourceInfo> getResource(String resourceType) {
        return this.getResource(resourceType, null);
    }

    private List<EntityResourceInfo> getResource(String resourceType, String name) {
        LinkedList<EntityResourceInfo> list = new LinkedList<EntityResourceInfo>();
        boolean isMatch = false;
        for (EntityResourceInfo entityResourceInfo : this.entityResourceInfoList) {
            if (resourceType != null) {
                isMatch = resourceType.equals(entityResourceInfo.getResourceType());
            }
            if (name != null && isMatch) {
                isMatch = name.equals(entityResourceInfo.getName());
            }
            if (!isMatch) continue;
            list.add(entityResourceInfo);
        }
        return list;
    }

    public void load() {
        this.loadEntityModel(true);
        this.loadEntityData();
    }

    public void loadEntityModel(boolean updateDb) {
        String sqlType = this.ormConfig.getSqlType();
        Assert.notNull((Object)sqlType, (String)"sqlType is not assign");
        Assert.notNull((Object)this.entityScriptExecutor, (String)"entityScriptExecutor is not assign");
        try {
            if (UtilString.isBlank((CharSequence)sqlType)) {
                throw new Exception("not specified sql type ");
            }
            EntityModelReader entityModelReader = new EntityModelReader();
            for (EntityResourceInfo resource : this.getResource("model")) {
                entityModelReader.buildModel(resource.getDocument());
            }
            entityModelReader.merge();
            EntityResourceInfo resourceInfo = (EntityResourceInfo)((Object)UtilCollection.at(this.getResource("fieldType", sqlType), (int)0));
            if (resourceInfo == null) {
                throw new Exception("not found fieldTypeDef \uff1a " + sqlType);
            }
            entityModelReader.buildModelFieldType(resourceInfo.getDocument(), sqlType);
            if (updateDb) {
                this.entityScriptExecutor.getDatabaseUtil().checkDb(ModelEntityUtil.getModelEntityList(), this.ormConfig);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void loadEntityData() {
        Assert.notNull((Object)this.entityScriptExecutor, (String)"entityScriptExecutor is not assign");
        try {
            LinkedList entityGroupList = new LinkedList();
            EntityDataReader dataReader = new EntityDataReader();
            for (EntityResourceInfo resource : this.getResource("data")) {
                dataReader.loadToEntity(resource.getDocument());
            }
            if (UtilCollection.isEmpty(entityGroupList)) {
                return;
            }
            for (final EntityGroup entityGroup : entityGroupList) {
                try {
                    TransactionScript transactionScript = this.entityScriptExecutor.beginTransaction(true);
                    transactionScript.execute(new TransactionExecutor(){

                        @Override
                        public void execute() {
                            for (EntityObject entityObject : entityGroup.getEntities()) {
                                EntityInsertScript insertScript = new EntityInsertScript(entityObject.getEntityName());
                                insertScript.addFields(entityObject);
                                EntityLoader.this.entityScriptExecutor.execute(insertScript);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    this.logger.warn("[loader] load entity data error, ", (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public EntityScriptExecutor getEntityScriptExecutor() {
        return this.entityScriptExecutor;
    }

    public void setEntityScriptExecutor(EntityScriptExecutor entityScriptExecutor) {
        this.entityScriptExecutor = entityScriptExecutor;
    }

    public List<EntityResourceInfo> getEntityResourceInfoList() {
        return this.entityResourceInfoList;
    }

    public void setEntityResourceInfoList(List<EntityResourceInfo> entityResourceInfoList) {
        this.entityResourceInfoList = entityResourceInfoList;
    }

    public OrmConfig getOrmConfig() {
        return this.ormConfig;
    }

    public void setOrmConfig(OrmConfig ormConfig) {
        this.ormConfig = ormConfig;
    }
}

