/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity;

import com.sprite.framework.entity.DataScriptStatement;
import com.sprite.framework.entity.EntityException;
import com.sprite.framework.entity.condition.CollectionEntityComparisonOperator;
import com.sprite.framework.entity.condition.CollectionOperateValue;
import com.sprite.framework.entity.condition.EmptyCondition;
import com.sprite.framework.entity.condition.EntityComparisonOperator;
import com.sprite.framework.entity.condition.EntityConditionList;
import com.sprite.framework.entity.condition.EntityExpr;
import com.sprite.framework.entity.condition.EntityFieldMap;
import com.sprite.framework.entity.condition.EntityJoinOperator;
import com.sprite.framework.entity.condition.EntityOperator;
import com.sprite.framework.entity.condition.MultiOperateValue;
import com.sprite.framework.entity.condition.NoParameterized;
import com.sprite.framework.entity.model.ModelEntityView;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public interface EntityCondition {
    public static final EntityCondition AnyCondition = EntityCondition.makeCondition(new NoParameterized("1"), EntityOperator.EQUALS, new NoParameterized("1"));

    public void makeScript(DataScriptStatement var1, ModelEntityView var2) throws EntityException;

    default public EntityCondition and(EntityCondition entityCondition) {
        if (entityCondition == null) {
            return this;
        }
        return EntityCondition.makeCondition(this, EntityJoinOperator.AND, entityCondition);
    }

    default public EntityCondition or(EntityCondition entityCondition) {
        if (entityCondition == null) {
            return this;
        }
        return EntityCondition.makeCondition(this, EntityJoinOperator.OR, entityCondition);
    }

    public static <R> EntityCondition notEqual(String fieldName, Object value) {
        return EntityCondition.makeCondition(fieldName, EntityOperator.NOT_EQUALS, value);
    }

    public static <R> EntityCondition in(String fieldName, Collection<?> values) {
        return EntityCondition.makeCondition(fieldName, EntityOperator.IN, values);
    }

    public static <R> EntityCondition in(String fieldName, MultiOperateValue values) {
        return EntityCondition.makeCondition(fieldName, EntityOperator.IN, values);
    }

    public static <R> EntityCondition like(String fieldName, String value) {
        return EntityCondition.makeCondition(fieldName, EntityOperator.LIKE, value);
    }

    public static <R> EntityCondition equal(String fieldName, Object value) {
        return EntityCondition.makeCondition(fieldName, value);
    }

    public static <R> EntityCondition gatherThan(String fieldName, Object value) {
        return EntityCondition.makeCondition(fieldName, EntityOperator.GREATER_THAN, value);
    }

    public static <R> EntityCondition gatherEqual(String fieldName, Object value) {
        return EntityCondition.makeCondition(fieldName, EntityOperator.GREATER_THAN_EQUAL_TO, value);
    }

    public static <R> EntityCondition lessThan(String fieldName, Object value) {
        return EntityCondition.makeCondition(fieldName, EntityOperator.LESS_THAN, value);
    }

    public static <R> EntityCondition lessEqual(String fieldName, Object value) {
        return EntityCondition.makeCondition(fieldName, EntityOperator.LESS_THAN_EQUAL_TO, value);
    }

    public static <R> EntityCondition fieldEqual(String fieldName, String field) {
        return EntityCondition.makeCondition(fieldName, new NoParameterized(field, false));
    }

    public static <R> EntityCondition isNull(String fieldName) {
        return EntityCondition.makeCondition(fieldName, EntityOperator.IS_NULL, NoParameterized.NULL);
    }

    public static <R> EntityCondition isNotNull(String fieldName) {
        return EntityCondition.makeCondition(fieldName, EntityOperator.NOT_NULL, NoParameterized.NULL);
    }

    public static <L, R, LL, RR> EntityExpr makeCondition(L l, EntityComparisonOperator<LL, RR> op, R r) {
        EntityExpr expr = new EntityExpr();
        expr.init(l, op, r);
        return expr;
    }

    public static <R, T extends MultiOperateValue> EntityExpr makeCondition(String l, CollectionEntityComparisonOperator<T> op, Collection<R> r) {
        return EntityCondition.makeCondition(l, op, new CollectionOperateValue(r));
    }

    public static <R, T extends MultiOperateValue> EntityExpr makeCondition(String l, CollectionEntityComparisonOperator<T> op, MultiOperateValue r) {
        EntityExpr expr = new EntityExpr();
        expr.init(l, op, r);
        return expr;
    }

    public static <R> EntityExpr makeCondition(String fieldName, R value) {
        return EntityCondition.makeCondition(fieldName, EntityOperator.EQUALS, value);
    }

    public static EntityExpr makeCondition(EntityCondition lhs, EntityJoinOperator operator, EntityCondition rhs) {
        EntityExpr expr = new EntityExpr();
        expr.init(lhs, operator, rhs);
        return expr;
    }

    public static <T extends EntityCondition> EntityConditionList<T> makeCondition(EntityJoinOperator operator, List<T> conditionList) {
        EntityConditionList<T> ecl = new EntityConditionList<T>();
        ecl.init(operator, conditionList);
        return ecl;
    }

    @SafeVarargs
    public static <T extends EntityCondition> EntityConditionList<T> makeCondition(T ... conditionList) {
        LinkedList<T> list = new LinkedList<T>();
        if (conditionList != null) {
            for (T t : conditionList) {
                if (t == null) continue;
                list.add(t);
            }
        }
        EntityConditionList<T> ecl = new EntityConditionList<T>();
        ecl.init(EntityOperator.AND, list);
        return ecl;
    }

    @SafeVarargs
    public static <T extends EntityCondition> EntityConditionList<T> makeCondition(EntityJoinOperator op, T ... conditionList) {
        EntityConditionList<T> ecl = new EntityConditionList<T>();
        ecl.init(op, Arrays.asList(conditionList));
        return ecl;
    }

    public static EntityFieldMap makeCondition(Map<String, ?> fieldMap) {
        EntityFieldMap efm = new EntityFieldMap();
        efm.init(fieldMap, EntityOperator.EQUALS, EntityOperator.AND);
        return efm;
    }

    public static EntityCondition any() {
        return AnyCondition;
    }

    public static EntityCondition empty() {
        return EmptyCondition.getInstance();
    }
}

