package com.sprite.framework.entity.util;

import com.sprite.utils.UtilString;

/**
 * @author Jack
 * @since 1.1.1
 */
public class SqlUtil {
    public static String DATABASE_TYPE_SQLSERVER = "sqlserver";
    public static String DATABASE_TYPE_SQLSERVER2008 = "sqlserver2008";
    public static String DATABASE_TYPE_SQLSERVER2012 = "sqlserver2012";
    public static String DATABASE_TYPE_MYSQL = "mysql";
    public static String DATABASE_TYPE_ORACLE = "oracle";
    public static String DATABASE_TYPE_PGSQL = "pgsql";

    public static String makeOffset(String sql, int offset, int limit, String dbtype, String orderBy) {

        if (DATABASE_TYPE_MYSQL.equals(dbtype)) {
            String temp = "{} LIMIT {},{}";
            return UtilString.place(temp, sql, offset, limit);
        } else if (DATABASE_TYPE_SQLSERVER2012.equals(dbtype)) {
            String temp = "{} OFFSET {} ROW FETCH NEXT  {} ROWS only ";
            return UtilString.place(temp, sql, offset, limit);
        } else if (DATABASE_TYPE_PGSQL.equals(dbtype)) {
            String temp = "{} LIMIT {} OFFSET {} ";
            return UtilString.place(temp, sql, limit, offset);
        }

        if (DATABASE_TYPE_SQLSERVER2008.equals(dbtype)) {
            if (UtilString.isBlank(orderBy)) {
                throw new IllegalArgumentException(" orderBy must, if dbtype is  : " + dbtype);
            }

            sql = sql.trim();
            int index = sql.indexOf(' ');
            if(index >=0){
                sql = sql.substring(index);
            }

            String temp = "SELECT TOP {} _rn.* from (SELECT row_number() over({}) as _rnum,* from(select top {} {}) as _rf) as _rn WHERE _rnum>{}";
            return UtilString.place(temp, offset+limit, orderBy, offset+limit,sql, offset);
        }else if (DATABASE_TYPE_SQLSERVER.equals(dbtype)) {
            if (UtilString.isBlank(orderBy)) {
                throw new IllegalArgumentException(" orderBy must, if dbtype is  : " + dbtype);
            }

            String temp = "SELECT TOP {} _rn.* from (SELECT row_number() over({}) as _rnum,* from({}) as _rf) as _rn WHERE _rnum>{}";
            return UtilString.place(temp, offset+limit, orderBy, sql, offset);
        } else if (DATABASE_TYPE_ORACLE.equals(dbtype)) {
            String temp = "SELECT * FROM(SELECT a.*,ROWNUM _rnum FROM({}) _rn WHERE ROWNUM<=({})) WHERE _rnum>{}";
            return UtilString.place(temp, sql, offset + limit, offset);
        }

        throw new IllegalArgumentException(" un support dbtype : " + dbtype);
    }
}
