package com.sprite.framework.entity.util;

/**
 * ORM相关配置
 */
public class OrmConfig {

	private  volatile  static OrmConfig config;

	public static void setConfig(OrmConfig ormConfig) {
		if (config == null) {
			synchronized (OrmConfig.class) {
				if (config == null) {
					config = ormConfig;
				}
			}
		}
	}

	public static OrmConfig getConfig(){
		return config;
	}

    private boolean openLog;    // 是否开启SQL日志
    private boolean cachedMapper;    // 是否缓存Mapper
    private String sqlType;    // sql 类型
    private boolean ddlAuto;    // 是否更新ddl

	public boolean isOpenLog() {
		return openLog;
	}

	public void setOpenLog(boolean openLog) {
		this.openLog = openLog;
	}

	public boolean isCachedMapper() {
		return cachedMapper;
	}

	public void setCachedMapper(boolean cachedMapper) {
		this.cachedMapper = cachedMapper;
	}

	public String getSqlType() {
		return sqlType;
	}

	public void setSqlType(String sqlType) {
		this.sqlType = sqlType;
	}

	public boolean isDdlAuto() {
		return ddlAuto;
	}

	public void setDdlAuto(boolean ddlAuto) {
		this.ddlAuto = ddlAuto;
	}
}
