package com.sprite.framework.entity.config;

import com.sprite.framework.component.SpriteConfig;
import com.sprite.framework.config.ResourceInfo;
import com.sprite.utils.UtilXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * 实体相关资源
 *
 * @author Jack
 */
public class EntityResourceInfo extends ResourceInfo {

    /**
     * @param elements
     * @return
     * @since 1.1.1
     */
    public static List<EntityResourceInfo> resolveResourceInfo(List<Element> elements, SpriteConfig spriteConfig) {
        List<EntityResourceInfo> list = new LinkedList<>();
        for (Element element : elements) {
            if (!"entity-resource".equals(element.getTagName())) {
                continue;
            }

            String type = element.getAttribute("type");
            String location = spriteConfig.relativeResource(element.getAttribute("location")).toString();
            EntityResourceInfo resourceInfo = new EntityResourceInfo(location, type);
            resourceInfo.setName(element.getAttribute("name"));
            list.add(resourceInfo);
        }

        return list;
    }

    private String resourceType; // resourceType
    private String name;

    public EntityResourceInfo(String location, String resourceType) {
        this.location = location;
        this.resourceType = resourceType;
    }


    public Document getDocument() throws Exception {
        return UtilXml.readXmlDocument(getStream(), false, null);
    }

    public String getResourceType() {
        return resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

}
