package com.sprite.framework.entity.support.spring;

import com.sprite.framework.component.SpriteConfig;
import com.sprite.framework.context.ContextEnvironment;
import com.sprite.framework.entity.EntityLoader;
import com.sprite.framework.entity.EntityScriptExecutor;
import com.sprite.utils.UtilCollection;
import com.sprite.utils.UtilString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

import java.util.List;

/**
 * @author Jack
 * @since 1.1.0
 */
public class SpriteOrmLoader implements ApplicationListener<ContextRefreshedEvent> {

    private Logger logger = LoggerFactory.getLogger(getClass());

    private volatile boolean inited = false;

    @Autowired
    private EntityScriptExecutor entityScriptExecutor;

    /**
     * Handle an application event.
     *
     * @param event
     *         the event to respond to
     */
    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if(inited){
            return;
        }
        initOrm();
        inited = true;
    }

    private void initOrm(){
        if(entityScriptExecutor == null){
            throw new RuntimeException("not found entityScriptExecutor");
        }

        String loaders = ContextEnvironment.getProperty("sprite.loaders", "main");
        String sqlType = ContextEnvironment.getProperty("sprite.orm.sqltype");
        String ddlauto = ContextEnvironment.getProperty("sprite.orm.ddlauto", "true");

        if(UtilString.isBlank(sqlType)) {
            throw new RuntimeException("not specified sql type ");
        }

        List<String> loaderList = UtilString.commaDelimiteToStringList(loaders);

        List<SpriteConfig> componentConfigs;
        try {
            componentConfigs = SpriteConfig.getAllComponents();

            if(UtilCollection.isEmpty(componentConfigs)){
                logger.info("[initOrm] not found sprite.xml");
                return;
            }

            for(SpriteConfig spriteConfig : componentConfigs) {
                spriteConfig.configure(loaderList);
            }


            EntityLoader entityLoader = new EntityLoader();
            entityLoader.setEntityScriptExecutor(entityScriptExecutor);
            entityLoader.setSqlType(sqlType);

            entityLoader.loadEntityModel("true".equalsIgnoreCase(ddlauto));
            entityLoader.loadEntityData();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
