package com.sprite.framework.entity.support.spring;

import com.sprite.framework.entity.*;
import com.sprite.framework.entity.bridge.JdbcTemplateBridge;
import com.sprite.framework.entity.mapper.DefaultStatementDelegator;
import com.sprite.framework.entity.mapper.StatementDelegator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;
import java.util.List;

/**
 * @author Jack
 * @since 1.1.0
 */
@Configuration
public class SpriteOrmConfiguration {

    @Autowired(required = false)
    private EntityInterceptor entityInterceptor;

    @Autowired
    private EntityScriptExecutor entityScriptExecutor;

    @Autowired(required = false)
    private List<IdGenerator> generatorList;

    @Bean
    public Delegator delegator(){
        GenericDelegator delegator = new GenericDelegator();
        delegator.setEntityInterceptor(entityInterceptor);
        delegator.addGenerator(generatorList);
        delegator.setScriptExecutor(entityScriptExecutor);
        return delegator;
    }

    @Bean
    public EntityScriptExecutor scriptExecutor(DataSource dataSource){
        JdbcTemplateBridge jdbcTemplateBridge = new JdbcTemplateBridge();

        JdbcTemplate jdbcTemplate = new JdbcTemplate();
        jdbcTemplate.setDataSource(dataSource);
        jdbcTemplateBridge.setJdbcTemplate(jdbcTemplate);

        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager();
        dataSourceTransactionManager.setDataSource(dataSource);
        jdbcTemplateBridge.setPlatformTransactionManager(dataSourceTransactionManager);

        return jdbcTemplateBridge;
    }

    @Bean
    public StatementDelegator statementDelegator(){
        return new DefaultStatementDelegator();
    }

    @Bean
    public SpriteOrmLoader spriteOrmLoader(){
        return new SpriteOrmLoader();
    }

}
