package com.sprite.framework.entity;

import com.sprite.framework.entity.condition.EntityJoinOperator;
import com.sprite.framework.entity.condition.MultiOperateValue;
import com.sprite.framework.entity.model.ModelEntityView;

import java.util.Collection;
import java.util.List;

/**
 * 非线程安全
 * @author Jack
 * @since 1.0.4
 */
public class EntityConditionBuilder implements EntityCondition{
    protected EntityCondition whereCondition = EntityCondition.empty();

    protected EntityConditionBuilder(){}

    public EntityConditionBuilder makeBuilder(){
        return new EntityConditionBuilder();
    }

    @Override
    public void makeScript(DataScriptStatement script, ModelEntityView modelViewEntity) throws EntityException {
        whereCondition.makeScript(script, modelViewEntity);
    }

    public EntityCondition build(){
        return whereCondition;
    }

    public EntityConditionBuilder and(EntityCondition condition){
        whereCondition = whereCondition.and(condition);
        return this;
    }

    public EntityConditionBuilder or(EntityCondition condition){
        whereCondition = whereCondition.or(condition);
        return this;
    }

    public EntityConditionBuilder notEqual(String fieldName, Object value){
        return and(EntityCondition.notEqual(fieldName, value));
    }

    public EntityConditionBuilder in(String fieldName, Collection<?> values){
        return and(EntityCondition.in(fieldName, values));
    }


    public EntityConditionBuilder in(String fieldName, MultiOperateValue values){
        return and(EntityCondition.in(fieldName, values));
    }

    public EntityConditionBuilder like(String fieldName, String value){
        return and(EntityCondition.like(fieldName, value));
    }

    public EntityConditionBuilder equal(String fieldName, String value){
        return and(EntityCondition.equal(fieldName, value));
    }

    public EntityConditionBuilder gatherThan(String fieldName, String value){
        return and(EntityCondition.gatherThan(fieldName, value));
    }

    public EntityConditionBuilder gatherEqual(String fieldName, String value){
        return and(EntityCondition.gatherEqual(fieldName, value));
    }


    public EntityConditionBuilder lessThan(String fieldName, String value){
        return and(EntityCondition.lessThan(fieldName, value));
    }

    public EntityConditionBuilder lessEqual(String fieldName, String value){
        return and(EntityCondition.lessEqual(fieldName, value));
    }

    public EntityConditionBuilder fieldEqual(String fieldName, String value){
        return and(EntityCondition.fieldEqual(fieldName, value));
    }

    public EntityConditionBuilder isNull(String fieldName){
        return and(EntityCondition.isNull(fieldName));
    }

    public EntityConditionBuilder isNotNull(String fieldName){
        return and(EntityCondition.isNull(fieldName));
    }

    public EntityConditionBuilder any(){
       return and(EntityCondition.any());
    }

    public EntityConditionBuilder makeCondition(EntityJoinOperator operator, List<EntityCondition> conditionList){
        whereCondition = EntityCondition.makeCondition(operator, conditionList);
        return this;
    }

    public EntityConditionBuilder makeCondition(EntityJoinOperator operator, EntityCondition condition){
        whereCondition = EntityCondition.makeCondition(whereCondition, operator, condition);
        return this;
    }
}
