package com.sprite.framework.bone;

import com.sprite.framework.bone.config.JdbcConfig;
import com.sprite.framework.entity.support.spring.SpriteOrmConfiguration;
import com.sprite.framework.support.spring.SpringContextUtil;
import org.apache.commons.dbcp2.BasicDataSource;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import javax.sql.DataSource;

/**
 * @author Jack
 * @since 2.0.1
 */
@Configuration
@Import(SpriteOrmConfiguration.class)
public class SpriteBoneConfiguration {

    @Bean
    public SpringContextUtil springContextUtil(){
        return new SpringContextUtil();
    }

    @Bean
    public JdbcConfig jdbcConfig(){
        return new JdbcConfig();
    }

    @Bean
    public DataSource dataSource(JdbcConfig jdbcConfig){
        BasicDataSource basicDataSource = new BasicDataSource();
        basicDataSource.setDriverClassName(jdbcConfig.getJdbcDriverClass());
        basicDataSource.setUrl(jdbcConfig.getJdbcUrl());
        basicDataSource.setUsername(jdbcConfig.getUsername());
        basicDataSource.setPassword(jdbcConfig.getPassword());
        basicDataSource.setInitialSize(jdbcConfig.getInitialSize());
        basicDataSource.setMaxTotal(jdbcConfig.getMaxTotal());
        basicDataSource.setMaxIdle(jdbcConfig.getMaxIdle());
        basicDataSource.setMinIdle(jdbcConfig.getMinIdle());
        basicDataSource.setMaxWaitMillis(jdbcConfig.getMaxWaitMillis());
        basicDataSource.setTestOnBorrow(jdbcConfig.isTestOnReturn());
        basicDataSource.setTestOnCreate(jdbcConfig.isTestOnReturn());
        basicDataSource.setTestOnReturn(jdbcConfig.isTestOnReturn());
        basicDataSource.setTestWhileIdle(jdbcConfig.isTestWhileIdle());
        basicDataSource.setTimeBetweenEvictionRunsMillis(jdbcConfig.getTimeBetweenEvictionRunsMillis());
        basicDataSource.setMinEvictableIdleTimeMillis(jdbcConfig.getMinEvictableIdleTimeMillis());
        basicDataSource.setRemoveAbandonedTimeout(jdbcConfig.getRemoveAbandonedTimeout());
        basicDataSource.setLogAbandoned(jdbcConfig.isLogAbandoned());

        return basicDataSource;
    }

    @Bean
    public PropertyPlaceholderConfigurer propertyPlaceholderConfigurer(ApplicationContext applicationContext) throws Exception{
        PropertyPlaceholderConfigurer propertyPlaceholderConfigurer = new PropertyPlaceholderConfigurer();
        propertyPlaceholderConfigurer.setLocations(applicationContext.getResources(System.getProperty("sprite.properties")));
        return propertyPlaceholderConfigurer;
    }
}
