/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.bone;

import com.sprite.framework.bone.SpringContextUtil;
import com.sprite.framework.component.SpriteConfig;
import com.sprite.framework.context.ContextEnvironment;
import com.sprite.framework.entity.EntityLoader;
import com.sprite.framework.entity.EntityScriptExecutor;
import com.sprite.framework.start.Container;
import com.sprite.utils.UtilCollection;
import com.sprite.utils.UtilMisc;
import com.sprite.utils.UtilString;
import java.util.Collection;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpriteContainer
implements Container {
    private Logger logger = LoggerFactory.getLogger(SpriteContainer.class);
    List<String> loaderList = UtilMisc.toList((Object)"main");
    private CommandLine cmdLine;
    private boolean updateDb;

    public void init(String[] args) {
        Options options = new Options().addOption("loaders", true, "main, demo, default value is main");
        options.addOption("sqltype", true, "default sql type : mysql, support mysql,oracle,pgsql,sqlserver,sqlserver2012");
        options.addOption("install", false, "install db");
        DefaultParser parser = new DefaultParser();
        try {
            this.cmdLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        this.loaderList.add("main");
        if (this.cmdLine.hasOption("loaders")) {
            String option = this.cmdLine.getOptionValue("loaders");
            this.loaderList.addAll(UtilString.commaDelimiteToStringList((String)option));
        }
        this.updateDb = this.cmdLine.hasOption("install");
    }

    public void start() {
        try {
            List componentConfigs = SpriteConfig.getAllComponents();
            if (UtilCollection.isEmpty((Collection)componentConfigs)) {
                this.logger.info("[SpriteContainer] not found sprite.xml");
                return;
            }
            for (SpriteConfig spriteConfig : componentConfigs) {
                spriteConfig.configure(this.loaderList);
            }
            String sqlType = this.cmdLine.getOptionValue("sqltype");
            if (sqlType == null) {
                sqlType = ContextEnvironment.getProperty((String)"sprite.sqltype");
            }
            if (UtilString.isBlank((CharSequence)sqlType)) {
                throw new Exception("not specified sql type ");
            }
            EntityLoader entityLoader = new EntityLoader();
            entityLoader.setEntityScriptExecutor(SpringContextUtil.getBean(EntityScriptExecutor.class));
            entityLoader.setSqlType(sqlType);
            entityLoader.loadEntityModel(this.updateDb);
            entityLoader.loadEntityData();
            if (this.updateDb) {
                this.logger.info("load success");
                System.exit(0);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
    }
}

