/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.component.web;

import com.sprite.framework.context.ContextEnvironment;
import com.sprite.framework.start.Container;
import javax.servlet.ServletException;
import org.apache.catalina.startup.Tomcat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatContainer
implements Container {
    private Logger logger = LoggerFactory.getLogger(TomcatContainer.class);
    private Tomcat tomcat;

    public void start() {
        if (this.tomcat == null) {
            this.tomcat = new Tomcat();
        }
        try {
            this.init();
            this.tomcat.start();
            this.tomcat.getServer().await();
        }
        catch (Exception e) {
            this.logger.error("[TomcatContainer][start] http server start error", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.tomcat.stop();
        }
        catch (Exception e) {
            this.logger.error("[TomcatContainer][stop] http server stop error", (Throwable)e);
        }
    }

    private void init() throws ServletException {
        int port = ContextEnvironment.getPropertyAsInt((String)"server.port");
        String docBase = ContextEnvironment.getProperty((String)"server.docBase");
        String appBase = ContextEnvironment.getProperty((String)"server.appBase", (String)".");
        String contextPath = ContextEnvironment.getProperty((String)"server.contextPath", (String)"");
        String baseDir = ContextEnvironment.getProperty((String)"tomcat.baseDir", (String)".");
        this.tomcat.setBaseDir(baseDir);
        this.tomcat.setPort(port);
        this.tomcat.setHostname("localhost");
        this.tomcat.getHost().setAppBase(appBase);
        this.tomcat.addWebapp(contextPath, docBase);
    }

    public void init(String[] args) {
    }
}

