/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.component.web;

import com.sprite.framework.context.ContextEnvironment;
import com.sprite.framework.start.Container;
import javax.servlet.ServletException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyContainer
implements Container {
    private Logger logger = LoggerFactory.getLogger(JettyContainer.class);
    private Server server;

    public void start() {
        try {
            this.init();
            this.server.start();
        }
        catch (Exception e) {
            this.logger.error("[JettyContainer][start] http server start error", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            this.logger.error("[JettyContainer][stop] http server stop error", (Throwable)e);
        }
    }

    private void init() throws ServletException {
        if (this.server == null) {
            this.server = new Server(ContextEnvironment.getPropertyAsInt((String)"server.port"));
        }
        String appBase = ContextEnvironment.getProperty((String)"server.appBase", (String)".");
        String contextPath = ContextEnvironment.getProperty((String)"server.contextPath", (String)"");
        WebAppContext webAppContext = new WebAppContext(appBase, contextPath);
        webAppContext.setDefaultsDescriptor("jetty/web-default.xml");
        this.server.setHandler((Handler)webAppContext);
    }

    public void init(String[] args) {
    }
}

