package com.sprite.component.web;

import com.sprite.framework.start.Container;

/**
 * @author Jack
 * @since 1.0.0
 */
public class WebContainer implements Container {
    private Container container;

    @Override
    public void init(String[] strings) {
        container = loadContainer("com.sprite.component.web.TomcatContainer");
        if (container == null) {
            container = loadContainer("com.sprite.component.web.JettyContainer");
        }
    }

    @Override
    public void start() {
        container.start();
    }

    @Override
    public void stop() {

    }

    private Container loadContainer(String className) {
        try {
            Class<?> container = Class.forName(className);
            Container instance = null;
            if (Container.class.isAssignableFrom(container)) {
                instance = (Container) container.newInstance();
            }
            return instance;
        } catch (Exception e) {
            return null;
        } catch (Error e) {
            return null;
        }
    }
}
