package com.sprite.component.web;

import com.sprite.framework.context.ContextEnvironment;
import com.sprite.framework.start.Container;
import org.apache.catalina.startup.Tomcat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.ServletException;

/**
 * @author Jack
 */
public class TomcatContainer implements Container {

	private Logger logger = LoggerFactory.getLogger(TomcatContainer.class);

	private Tomcat tomcat;
	public void start() {
		if(tomcat == null){
			tomcat = new Tomcat();
		}

		try {
			init();
			tomcat.start();
			tomcat.getServer().await();
		} catch (Exception e) {
			logger.error("[TomcatContainer][start] http server start error", e);
		} 

	}

	public void stop() {
		try {
			tomcat.stop();
		} catch (Exception e) {
			logger.error("[TomcatContainer][stop] http server stop error", e);
		} 
	}

	private void init() throws ServletException{
		int port = ContextEnvironment.getPropertyAsInt("server.port");
		String docBase = ContextEnvironment.getProperty("server.docBase");
		String appBase = ContextEnvironment.getProperty("server.appBase", ".");
		String contextPath = ContextEnvironment.getProperty("server.contextPath", "");
		String baseDir = ContextEnvironment.getProperty("tomcat.baseDir", ".");
		tomcat.setBaseDir(baseDir);
		tomcat.setPort(port);
		tomcat.setHostname("localhost");
		tomcat.getHost().setAppBase(appBase);

		tomcat.addWebapp(contextPath, docBase);
	}

	@Override
	public void init(String[] args) {
		
	}

}
