package com.sprite.component.web;

import javax.servlet.ServletException;

import com.sprite.framework.context.ContextEnvironment;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sprite.framework.start.Container;

/**
 * @author Jack
 */
public class JettyContainer implements Container {

	private Logger logger = LoggerFactory.getLogger(JettyContainer.class);

	private Server server;
	public void start() {
		try {
			init();
			server.start();
		} catch (Exception e) {
			logger.error("[JettyContainer][start] http server start error", e);
		} 

	}

	public void stop() {
		try {
			server.stop();
		} catch (Exception e) {
			logger.error("[JettyContainer][stop] http server stop error", e);
		} 
	}

	private void init() throws ServletException{
		if(server == null){
			server = new Server(ContextEnvironment.getPropertyAsInt("server.port"));
		}
		String appBase = ContextEnvironment.getProperty("server.appBase", ".");
		String contextPath = ContextEnvironment.getProperty("server.contextPath", "");
		
		WebAppContext webAppContext = new WebAppContext(appBase, contextPath);  
		webAppContext.setDefaultsDescriptor("jetty/web-default.xml");
		server.setHandler(webAppContext);
	}

	@Override
	public void init(String[] args) {
		
	}

}
