/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.util;

import cn.zhxu.toys.util.NumUtils;
import cn.zhxu.toys.util.StringUtils;

public class ByteUtils {
    public static boolean equals(byte[] arr1, byte[] arr2) {
        if (arr1 == null && arr2 == null) {
            return true;
        }
        if (arr1 == null || arr2 == null || arr1.length != arr2.length) {
            return false;
        }
        for (int i = 0; i < arr1.length; ++i) {
            if (arr1[i] == arr2[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[][] split(byte[] arr, byte separator) {
        int count = ByteUtils.countOf(arr, separator);
        byte[][] result = new byte[count + 1][];
        int index = ByteUtils.indexOf(arr, separator, 0, arr.length);
        if (index < 0) {
            result[0] = arr;
        } else {
            result[0] = ByteUtils.subArray(arr, 0, index);
            for (int i = 1; i <= count; ++i) {
                int from = index + 1;
                if ((index = ByteUtils.indexOf(arr, separator, from, arr.length)) < from) {
                    index = arr.length;
                }
                result[i] = ByteUtils.subArray(arr, from, index);
            }
        }
        return result;
    }

    public static int indexOf(byte[] arr, byte target, int from, int to) {
        for (int i = from; i < to; ++i) {
            if (arr[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int countOf(byte[] arr, byte target) {
        int count = 0;
        for (byte b : arr) {
            if (b != target) continue;
            ++count;
        }
        return count;
    }

    public static byte[] subArray(byte[] arr, int from) {
        return ByteUtils.subArray(arr, from, arr.length);
    }

    public static byte[] subArray(byte[] arr, int from, int to) {
        byte[] result = new byte[to - from];
        if (to > from) {
            System.arraycopy(arr, from, result, 0, result.length);
        }
        return result;
    }

    public static byte[] join(byte hyphen, byte[] ... arrs) {
        int length = 0;
        for (byte[] arr : arrs) {
            length += arr.length;
        }
        byte[] result = new byte[length + arrs.length - 1];
        int index = 0;
        for (int i = 0; i < arrs.length; ++i) {
            byte[] arr;
            arr = arrs[i];
            System.arraycopy(arr, 0, result, index, arr.length);
            index += arr.length;
            if (i >= arrs.length - 1) continue;
            result[index] = hyphen;
            ++index;
        }
        return result;
    }

    public static byte[] join(byte[] ... arrs) {
        int length = 0;
        for (byte[] arr : arrs) {
            length += arr.length;
        }
        byte[] result = new byte[length];
        int index = 0;
        for (byte[] arr : arrs) {
            System.arraycopy(arr, 0, result, index, arr.length);
            index += arr.length;
        }
        return result;
    }

    public static byte[] trim(byte[] src, byte empty) {
        return ByteUtils.trim(src, empty, 0, src.length);
    }

    public static byte[] trim(byte[] src, byte empty, int from, int to) {
        while (from < src.length - 1 && src[from] == empty) {
            ++from;
        }
        while (to > from && src[to - 1] == empty) {
            --to;
        }
        return ByteUtils.subArray(src, from, to);
    }

    public static String bcd(byte[] src, int from, int to) {
        char[] chars = new char[2 * (to - from)];
        for (int i = from; i < to; ++i) {
            int b = NumUtils.unsigned(src[i]);
            chars[2 * (i - from)] = (char)((b >> 4) + 48);
            chars[2 * (i - from) + 1] = (char)((b & 0xF) + 48);
        }
        return new String(chars);
    }

    public static int xor(byte[] bytes) {
        int temp = 0;
        if (bytes != null) {
            for (byte aByte : bytes) {
                temp ^= aByte;
            }
        }
        return temp;
    }

    public static byte[] hexToBytes(String hexContent) {
        if (StringUtils.isBlank(hexContent) || hexContent.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        byte[] bytes = new byte[hexContent.length() / 2];
        char[] chars = hexContent.toCharArray();
        for (int i = 0; i < hexContent.length() / 2; ++i) {
            int index = i * 2;
            byte a = (byte)Character.digit(chars[index], 16);
            byte b = (byte)Character.digit(chars[index + 1], 16);
            bytes[i] = (byte)(a << 4 | b);
        }
        return bytes;
    }
}

