/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.tree;

import cn.zhxu.toys.tree.TreeAble;
import cn.zhxu.toys.tree.TreeOutput;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TreeUtils {
    public static <T extends TreeAble, R extends TreeOutput<R>> List<R> buildTree(List<T> inputs, Function<T, R> convertor) {
        Stream<TreeAble> roots = inputs.stream().filter(i -> i.getParentId() == null || i.getParentId() == 0);
        return TreeUtils.doBuildTree(roots, inputs, convertor);
    }

    public static <T extends TreeAble, R extends TreeOutput<R>> List<R> doBuildTree(Stream<T> roots, List<T> inputs, Function<T, R> convertor) {
        return roots.map(input -> {
            Stream<TreeAble> list = inputs.stream().filter(i -> Objects.equals(i.getParentId(), input.getId()));
            TreeOutput result = (TreeOutput)convertor.apply(input);
            List children = TreeUtils.doBuildTree(list, inputs, convertor);
            result.setChildren(children);
            return result;
        }).collect(Collectors.toList());
    }
}

