/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.cipher;

import cn.zhxu.toys.cipher.CipherManager;
import cn.zhxu.toys.cipher.Decryptor;
import cn.zhxu.toys.cipher.Encryptor;
import org.springframework.beans.factory.InitializingBean;

public class DefaultCipherManager
implements CipherManager,
InitializingBean {
    private String secret;
    private Encryptor encryptor;
    private Decryptor decryptor;

    public void afterPropertiesSet() throws Exception {
        this.init(this.secret);
    }

    @Override
    public void init(String secret) {
        this.encryptor.init(secret);
        this.decryptor.init(secret);
    }

    @Override
    public String encrypt(String plainText) {
        return this.encryptor.encrypt(plainText);
    }

    @Override
    public String encrypt(String secret, String plainText) {
        return this.encryptor.encrypt(secret, plainText);
    }

    @Override
    public byte[] encrypt(byte[] secretBytes, byte[] plainBytes) {
        return this.encryptor.encrypt(secretBytes, plainBytes);
    }

    @Override
    public String decrypt(String cipherText) {
        return this.decryptor.decrypt(cipherText);
    }

    @Override
    public String decrypt(String secret, String cipherText) {
        return this.decryptor.decrypt(secret, cipherText);
    }

    @Override
    public byte[] encrypt(byte[] plainBytes) {
        return this.encryptor.encrypt(plainBytes);
    }

    @Override
    public byte[] decrypt(byte[] cipherBytes) {
        return this.decryptor.decrypt(cipherBytes);
    }

    @Override
    public byte[] decrypt(byte[] secretBytes, byte[] cipherBytes) {
        return this.decryptor.decrypt(cipherBytes, cipherBytes);
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public Encryptor getEncryptor() {
        return this.encryptor;
    }

    public void setEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
    }

    public Decryptor getDecryptor() {
        return this.decryptor;
    }

    public void setDecryptor(Decryptor decryptor) {
        this.decryptor = decryptor;
    }
}

