/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.captcha.impl;

import cn.zhxu.toys.captcha.CodeGenerator;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class RandomFormulaCodeGenerator
implements CodeGenerator {
    private static final char ADDITION = '+';
    private static final char SUBTRACTION = '-';
    private static final char MULTIPLY = '*';
    private static final char DIVISION = '\u00f7';
    private static final char[] OPERATORS = new char[]{'+', '-', '*', '\u00f7'};
    private static final char EQUAL_SIGN = '=';
    private static final Random random = ThreadLocalRandom.current();
    private int length = 6;
    private boolean allowNegative = false;

    public RandomFormulaCodeGenerator() {
    }

    public RandomFormulaCodeGenerator(int length) {
        this(length, false);
    }

    public RandomFormulaCodeGenerator(int length, boolean allowNegative) {
        this.setLength(length);
        this.allowNegative = allowNegative;
    }

    @Override
    public CodeGenerator.CodeResult generate() {
        int[] nums = this.generateNumbers();
        char[] ops = this.generateOperators(nums);
        int result = this.compute(ops, nums);
        while (result == Integer.MAX_VALUE || !this.allowNegative && result < 0) {
            ops = this.generateOperators(nums);
            result = this.compute(ops, nums);
        }
        String code = this.buildCode(ops, nums);
        String check = String.valueOf(result);
        return new CodeGenerator.CodeResult(code, check);
    }

    private String buildCode(char[] ops, int[] nums) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ops.length; ++i) {
            sb.append(nums[i]).append(ops[i]);
        }
        sb.append(nums[nums.length - 1]);
        if (this.length % 2 == 0) {
            sb.append('=');
        }
        return sb.toString();
    }

    private int[] generateNumbers() {
        int[] nums = new int[(this.length + 1) / 2];
        for (int i = 0; i < nums.length; ++i) {
            nums[i] = random.nextInt(10);
        }
        return nums;
    }

    private char[] generateOperators(int[] nums) {
        char[] ops = new char[nums.length - 1];
        for (int i = 0; i < ops.length; ++i) {
            ops[i] = OPERATORS[random.nextInt(OPERATORS.length)];
        }
        return ops;
    }

    private int compute(char[] ops, int[] nums) {
        if (ops.length != nums.length - 1) {
            throw new IllegalArgumentException("Invalid ops or nums");
        }
        if (nums.length == 1) {
            return nums[0];
        }
        if (nums.length == 2) {
            return this.compute(ops[0], nums[0], nums[1]);
        }
        if (ops[0] == '*' || ops[0] == '\u00f7' || ops[1] == '+' || ops[1] == '-') {
            return this.compute(ops[1], this.compute(ops[0], nums[0], nums[1]), nums[2]);
        }
        return this.compute(ops[0], nums[0], this.compute(ops[1], nums[1], nums[2]));
    }

    private int compute(char op, int n1, int n2) {
        if (n1 == Integer.MAX_VALUE || n2 == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        switch (op) {
            case '+': {
                return n1 + n2;
            }
            case '-': {
                return n1 - n2;
            }
            case '*': {
                return n1 * n2;
            }
            case '\u00f7': {
                if (n2 == 0 || n1 % n2 != 0) {
                    return Integer.MAX_VALUE;
                }
                return n1 / n2;
            }
        }
        throw new IllegalArgumentException("Invalid Op: " + op);
    }

    public void setLength(int length) {
        this.length = Math.min(Math.max(1, length), 6);
    }

    public int getLength() {
        return this.length;
    }

    public boolean isAllowNegative() {
        return this.allowNegative;
    }

    public void setAllowNegative(boolean allowNegative) {
        this.allowNegative = allowNegative;
    }
}

