/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.captcha.impl;

import cn.zhxu.toys.captcha.CaptchaAttrs;
import cn.zhxu.toys.captcha.CaptchaException;
import cn.zhxu.toys.captcha.CodeRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.imageio.ImageIO;

public class ImageCodeRenderer
implements CodeRenderer {
    public static String ATTR_OUTPUT_STREAM = "outputStream";
    public static String ATTR_WIDTH = "width";
    public static String ATTR_HEIGHT = "height";
    private static final Random random = ThreadLocalRandom.current();
    private int defaultWidth = 120;
    private int defaultHeight = 40;

    @Override
    public void render(String code, CaptchaAttrs attrs) throws CaptchaException {
        OutputStream os = attrs.require(ATTR_OUTPUT_STREAM, OutputStream.class);
        Integer width = attrs.get(ATTR_WIDTH, Integer.class, this.defaultWidth);
        Integer height = attrs.get(ATTR_HEIGHT, Integer.class, this.defaultHeight);
        try {
            this.doRender(os, code, width, height);
        }
        catch (IOException e) {
            throw new CaptchaException("\u56fe\u7247\u9a8c\u8bc1\u7801\u6e32\u67d3\u5931\u8d25", e);
        }
    }

    public void doRender(OutputStream os, String code, int width, int height) throws IOException {
        int verifySize = code.length();
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g2 = image.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.GRAY);
        g2.fillRect(0, 0, width, height);
        Color c = ImageCodeRenderer.getRandColor(200, 250);
        g2.setColor(c);
        g2.fillRect(0, 2, width, height - 4);
        g2.setColor(ImageCodeRenderer.getRandColor(160, 200));
        for (int i = 0; i < 20; ++i) {
            int x = random.nextInt(width - 1);
            int y = random.nextInt(height - 1);
            int xl = random.nextInt(6) + 1;
            int yl = random.nextInt(12) + 1;
            g2.drawLine(x, y, x + xl + 40, y + yl + 20);
        }
        float yawpRate = 0.05f;
        int area = (int)(yawpRate * (float)width * (float)height);
        for (int i = 0; i < area; ++i) {
            int x = random.nextInt(width);
            int y = random.nextInt(height);
            int rgb = ImageCodeRenderer.getRandomIntColor();
            image.setRGB(x, y, rgb);
        }
        this.shear(g2, c, width, height);
        g2.setColor(ImageCodeRenderer.getRandColor(100, 160));
        int fontSize = height - 4;
        Font font = new Font("Algerian", 2, fontSize);
        g2.setFont(font);
        char[] chars = code.toCharArray();
        for (int i = 0; i < verifySize; ++i) {
            AffineTransform affine = new AffineTransform();
            affine.setToRotation(0.7853981633974483 * random.nextDouble() * (double)(random.nextBoolean() ? 1 : -1), (double)width / (double)verifySize * (double)i + (double)fontSize / 2.0, (double)height / 2.0);
            g2.setTransform(affine);
            g2.drawChars(chars, i, 1, (width - 10) / verifySize * i + 5, height / 2 + fontSize / 2 - 10);
        }
        g2.dispose();
        ImageIO.write((RenderedImage)image, "png", os);
    }

    private static Color getRandColor(int fc, int bc) {
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }

    private static int getRandomIntColor() {
        int[] rgb = ImageCodeRenderer.getRandomRgb();
        int color = 0;
        for (int c : rgb) {
            color <<= 8;
            color |= c;
        }
        return color;
    }

    private static int[] getRandomRgb() {
        int[] rgb = new int[3];
        for (int i = 0; i < 3; ++i) {
            rgb[i] = random.nextInt(255);
        }
        return rgb;
    }

    private void shear(Graphics g, Color color, int width, int height) {
        this.shearX(g, color, width, height);
        this.shearY(g, color, width, height);
    }

    private void shearX(Graphics g, Color color, int width, int height) {
        int period = random.nextInt(3);
        boolean frames = true;
        int phase = random.nextInt(2);
        for (int i = 0; i < height; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(0, i, width, 1, (int)d, 0);
            g.setColor(color);
            g.drawLine((int)d, i, 0, i);
            g.drawLine((int)d + width, i, width, i);
        }
    }

    private void shearY(Graphics g, Color color, int width, int height) {
        int period = random.nextInt(40) + 10;
        int frames = 20;
        int phase = 7;
        for (int i = 0; i < width; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(i, 0, 1, height, 0, (int)d);
            g.setColor(color);
            g.drawLine(i, (int)d, i, 0);
            g.drawLine(i, (int)d + height, i, height);
        }
    }

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public void setDefaultWidth(int defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    public int getDefaultHeight() {
        return this.defaultHeight;
    }

    public void setDefaultHeight(int defaultHeight) {
        this.defaultHeight = defaultHeight;
    }
}

