/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.util;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.UUID;

public class StringUtils {
    public static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toHexStr(byte[] bytes) {
        char[] str = new char[2 * bytes.length];
        int k = 0;
        for (byte b : bytes) {
            str[k++] = hexChars[b >>> 4 & 0xF];
            str[k++] = hexChars[b & 0xF];
        }
        return new String(str);
    }

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpperCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        if (len == 0) {
            return true;
        }
        block3: for (int i = 0; i < len; ++i) {
            switch (str.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean notBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static boolean notBlank(String ... strings) {
        if (strings == null) {
            return false;
        }
        for (String str : strings) {
            if (!StringUtils.isBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean notNull(Object ... paras) {
        if (paras == null) {
            return false;
        }
        for (Object obj : paras) {
            if (obj != null) continue;
            return false;
        }
        return true;
    }

    public static String join(String[] stringArray) {
        StringBuilder sb = new StringBuilder();
        for (String s : stringArray) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String getRandomUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String join(String[] strAry, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strAry.length; ++i) {
            if (i == strAry.length - 1) {
                sb.append(strAry[i]);
                continue;
            }
            sb.append(strAry[i]).append(separator);
        }
        return new String(sb);
    }

    public static String join(long[] array, String separator) {
        Object[] arr = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            arr[i] = array[i];
        }
        return StringUtils.join(arr, separator);
    }

    public static String join(Object[] array, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i == array.length - 1) {
                sb.append(array[i]);
                continue;
            }
            sb.append(array[i]).append(separator);
        }
        return new String(sb);
    }

    public static String getLastByToken(String src, String token) {
        if (src == null) {
            throw new IllegalArgumentException("src \u4e0d\u80fd\u4e3a null");
        }
        String[] splits = src.split(token);
        return splits[splits.length - 1];
    }

    public static String mask(String src, int from, char mask) {
        return StringUtils.mask(src, from, mask, src.length());
    }

    public static String mask(String src, char mask, int to) {
        return StringUtils.mask(src, 0, mask, to);
    }

    public static String mask(String src, int from, char mask, int to) {
        if (src == null) {
            return null;
        }
        if (to < from) {
            throw new IllegalArgumentException("'from' must less than 'to'!");
        }
        if (from < 0) {
            throw new IllegalArgumentException("'from' must greater than or equal 'to'!");
        }
        if (to > src.length()) {
            throw new IllegalArgumentException("'to' must less than or equal the length of 'src'!");
        }
        StringBuilder sb = new StringBuilder(src.substring(0, from));
        for (int i = from; i < to; ++i) {
            sb.append(mask);
        }
        sb.append(src.substring(to));
        return sb.toString();
    }

    public static String formatDateTimeWithMiliSecond(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return sdf.format(date);
    }

    public static String formatCode(long id) {
        return StringUtils.strFrom(id, 4) + StringUtils.formatDateTimeWithMiliSecond(new Date()) + StringUtils.randomNumString(5);
    }

    public static String strFrom(long code, int width) {
        StringBuilder str = new StringBuilder("" + code);
        while (str.length() < width) {
            str.insert(0, "0");
        }
        if (str.length() > width) {
            str = new StringBuilder(str.substring(str.length() - width));
        }
        return str.toString();
    }

    public static String randomNumString(int width) {
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < width; ++i) {
            sb.append(random.nextInt(10));
        }
        return sb.toString();
    }

    public static String toRmbStr(long amount) {
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format((double)amount / 100.0);
    }

    public static String toCamera(String src, String hyphenation, boolean initLetterLower) {
        if (StringUtils.isBlank(src)) {
            return src;
        }
        StringBuilder sb = new StringBuilder();
        String[] list = src.split(hyphenation);
        for (int i = 0; i < list.length; ++i) {
            if (i == 0 && initLetterLower) {
                sb.append(StringUtils.firstCharToLowerCase(list[i]));
                continue;
            }
            sb.append(StringUtils.firstCharToUpperCase(list[i]));
        }
        return sb.toString();
    }

    public static String toCamera(String src, String hyphenation) {
        return StringUtils.toCamera(src, hyphenation, true);
    }

    public static String toCamera(String src) {
        return StringUtils.toCamera(src, "_", true);
    }

    public static String toHyphenation(String src, String hyphenation) {
        StringBuilder sb = new StringBuilder(src);
        int temp = 0;
        for (int i = 0; i < src.length(); ++i) {
            if (!Character.isUpperCase(src.charAt(i))) continue;
            sb.insert(i + temp, hyphenation);
            ++temp;
        }
        return sb.toString().toLowerCase();
    }

    public static String toHyphenation(String src) {
        return StringUtils.toHyphenation(src, "_");
    }

    public static boolean hasCharacter(String src, char start, char end) {
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (c < start || c > end) continue;
            return true;
        }
        return false;
    }

    public static boolean hasUpperCase(String src) {
        return StringUtils.hasCharacter(src, 'A', 'Z');
    }

    public static boolean hasLowerCase(String src) {
        return StringUtils.hasCharacter(src, 'a', 'z');
    }

    public static boolean hasNumChar(String src) {
        return StringUtils.hasCharacter(src, '0', '9');
    }
}

