/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.oss;

import cn.zhxu.toys.oss.AbstractOssManager;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class AliyunOssManager
extends AbstractOssManager
implements InitializingBean,
DisposableBean {
    private String accessKeyId;
    private String accessKeySecret;
    private String bucketName;
    private OSSClient client;

    public void afterPropertiesSet() {
        this.client = new OSSClient(this.endpoint, (CredentialsProvider)new DefaultCredentialProvider(this.accessKeyId, this.accessKeySecret), null);
    }

    @Override
    public InputStream access(String key) {
        OSSObject ossObject = this.client.getObject(this.bucketName, key);
        return ossObject.getObjectContent();
    }

    @Override
    public String upload(String fileName, String key, String contentType, String extension, InputStream inputStream) {
        try {
            long fileSize = inputStream.available();
            if (fileSize > this.maxSize) {
                inputStream.close();
                throw new RuntimeException("\u4e0a\u4f20\u7684\u6587\u4ef6\u8fc7\u5927\uff1a" + fileSize + "\uff0c\u6700\u5927\u53ea\u5141\u8bb8\uff1a" + this.maxSize);
            }
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength((long)inputStream.available());
            metadata.setCacheControl("no-cache");
            metadata.setHeader("Pragma", (Object)"no-cache");
            metadata.setContentEncoding("utf-8");
            fileName = fileName == null ? System.currentTimeMillis() + (long)new Random().nextInt() + extension : fileName + extension;
            if (contentType != null) {
                metadata.setContentType(contentType);
            }
            metadata.setContentDisposition("filename/filesize=" + fileName + "/" + fileSize + "Byte.");
            if (!key.endsWith("/")) {
                key = key + "/";
            }
            String fileKey = key + fileName;
            this.client.putObject(this.bucketName, fileKey, inputStream, metadata);
            return this.resolveFileAccessUrl(fileKey);
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e0a\u4f20\u51fa\u73b0\u5f02\u5e38\uff1a", e);
        }
    }

    @Override
    public boolean delete(String fileUrl) {
        String fileKey = this.resolveFileKey(fileUrl);
        if (fileKey != null) {
            try {
                String decodedKey = URLDecoder.decode(fileKey, StandardCharsets.UTF_8.name());
                this.client.deleteObject(this.bucketName, decodedKey);
                return true;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public void destroy() {
        this.client.shutdown();
    }

    @Override
    protected String getBaseAccessUrl(String protocol, String host) {
        return protocol + this.bucketName + "." + host + "/";
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }
}

