/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.oss;

import cn.zhxu.toys.oss.OssManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public abstract class AbstractOssManager
implements OssManager {
    protected String endpoint;
    protected Long maxSize = 307200000L;

    @Override
    public String upload(String key, File file) {
        String extension = this.getFileExtension(file.getName());
        String contentType = this.getContentType(extension);
        try {
            return this.upload(null, key, contentType, extension, new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u4e0a\u4f20\u51fa\u9519\uff1a", e);
        }
    }

    @Override
    public String upload(String key, String contentType, InputStream inputStream) {
        return this.upload(null, key, contentType, this.toExtension(contentType), inputStream);
    }

    @Override
    public String upload(String fileName, String key, String contentType, InputStream inputStream) {
        int dotIndex;
        String extension = null;
        if (fileName != null && (dotIndex = fileName.lastIndexOf(46)) > 0 && dotIndex < fileName.length() - 1) {
            extension = fileName.substring(dotIndex);
            fileName = fileName.substring(0, dotIndex);
        }
        if (extension != null && contentType == null) {
            contentType = this.getContentType(extension);
        }
        if (contentType != null && extension == null) {
            extension = this.toExtension(contentType);
        }
        return this.upload(fileName, key, contentType, extension, inputStream);
    }

    public abstract String upload(String var1, String var2, String var3, String var4, InputStream var5);

    protected String resolveFileAccessUrl(String fileKey) {
        return this.getBaseUrl() + fileKey;
    }

    protected String resolveFileKey(String fileAccessUrl) {
        String baseUri;
        String accessUri;
        if (fileAccessUrl != null && (accessUri = this.uri(fileAccessUrl)).startsWith(baseUri = this.uri(this.getBaseUrl()))) {
            return accessUri.substring(baseUri.length());
        }
        return null;
    }

    private String uri(String url) {
        int idx = url.indexOf("://");
        if (idx > 0 && url.length() > idx + 3) {
            return url.substring(idx + 3);
        }
        return url;
    }

    protected String getBaseUrl() {
        String protocol = "https://";
        String host = this.endpoint;
        if (this.endpoint.startsWith("http://")) {
            host = host.substring(7);
            protocol = "http://";
        } else if (this.endpoint.startsWith("https://")) {
            host = host.substring(8);
        }
        if (host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        return this.getBaseAccessUrl(protocol, host);
    }

    protected abstract String getBaseAccessUrl(String var1, String var2);

    protected String getContentType(String fileExtension) {
        if (fileExtension != null && fileExtension.length() > 1) {
            switch (fileExtension.toLowerCase().substring(1)) {
                case "txt": {
                    return "text/plain";
                }
                case "json": {
                    return "application/json";
                }
                case "xml": {
                    return "text/xml";
                }
                case "js": {
                    return "text/javascript";
                }
                case "html": {
                    return "text/html";
                }
                case "bmp": {
                    return "image/bmp";
                }
                case "gif": {
                    return "image/gif";
                }
                case "jpeg": {
                    return "image/jpeg";
                }
                case "jpg": {
                    return "image/jpg";
                }
                case "png": {
                    return "image/png";
                }
                case "mp3": {
                    return "video/mp3";
                }
                case "wav": {
                    return "video/wav";
                }
                case "avi": {
                    return "video/avi";
                }
                case "mpg": {
                    return "video/mpg";
                }
                case "mpeg": {
                    return "video/mpeg";
                }
                case "mp4": {
                    return "video/mp4";
                }
                case "pdf": {
                    return "application/pdf";
                }
                case "ppt": {
                    return "application/vnd.ms-powerpoint";
                }
                case "pptx": {
                    return "application/vnd.openxmlformats-officedocument.presentationml.presentation";
                }
                case "doc": {
                    return "application/msword";
                }
                case "docx": {
                    return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
                }
                case "xls": {
                    return "application/vnd.ms-excel";
                }
                case "xlsx": {
                    return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
                }
                case "vsd": {
                    return "application/vnd.visio";
                }
            }
        }
        return null;
    }

    protected String toExtension(String contentType) {
        return ".*";
    }

    protected String getFileExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf("."));
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Long maxSize) {
        this.maxSize = maxSize;
    }
}

