/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.msg;

import cn.zhxu.toys.msg.AbstractMsgSender;
import cn.zhxu.toys.msg.MsgTemplate;
import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponse;
import com.aliyun.teaopenapi.models.Config;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunMsgSender
extends AbstractMsgSender {
    static Logger log = LoggerFactory.getLogger(AliyunMsgSender.class);
    public static String DEFAULT_ENDPOINT = "dysmsapi.aliyuncs.com";
    private String endpoint = DEFAULT_ENDPOINT;
    private String accessKeyId;
    private String accessKeySecret;
    private String signName;
    private Client client;

    @Override
    public void init(Map<String, String> params) {
        String endpoint = params.get("endpoint");
        String accessKeyId = params.get("accessKeyId");
        String accessKeySecret = params.get("accessKeySecret");
        String signName = params.get("signName");
        if (accessKeyId == null) {
            throw new AbstractMsgSender.MsgSenderInitException("\u7f3a\u5c11\u53c2\u6570\uff1aappId");
        }
        if (accessKeySecret == null) {
            throw new AbstractMsgSender.MsgSenderInitException("\u7f3a\u5c11\u53c2\u6570\uff1aaccessKeySecret");
        }
        if (signName == null) {
            throw new AbstractMsgSender.MsgSenderInitException("\u7f3a\u5c11\u53c2\u6570\uff1asignName");
        }
        if (endpoint != null) {
            this.endpoint = endpoint;
        }
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.signName = signName;
    }

    protected Client client() {
        if (this.client != null) {
            return this.client;
        }
        Config config = new Config().setEndpoint(Objects.requireNonNull(this.endpoint)).setAccessKeyId(Objects.requireNonNull(this.accessKeyId)).setAccessKeySecret(Objects.requireNonNull(this.accessKeySecret));
        try {
            this.client = new Client(config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.client;
    }

    @Override
    public boolean send(String phone, MsgTemplate template, String ... tmplArgs) {
        SendSmsResponse response;
        SendSmsRequest request = new SendSmsRequest();
        request.setSignName(Objects.requireNonNull(this.signName));
        request.setPhoneNumbers(phone);
        request.setTemplateCode(template.getTmplValue());
        Object[] argNames = template.getTmplArgs();
        StringBuilder sb = new StringBuilder();
        if (tmplArgs != null) {
            if (tmplArgs.length > 0 && (argNames == null || argNames.length < tmplArgs.length)) {
                throw new RuntimeException("MsgTemplate tmplArgs not match: " + Arrays.toString(argNames) + " to " + Arrays.toString(tmplArgs));
            }
            sb.append("{");
            for (int index = 0; index < tmplArgs.length; ++index) {
                sb.append("\"").append((String)argNames[index]).append("\":").append("\"").append(tmplArgs[index]).append("\"");
                if (index >= tmplArgs.length - 1) continue;
                sb.append(",");
            }
            sb.append("}");
        }
        request.setTemplateParam(sb.toString());
        try {
            response = this.client().sendSms(request);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response.statusCode == 200 && "OK".equals(response.getBody().code);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getSignName() {
        return this.signName;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }
}

