/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.client;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.ConnectException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.AsyncClientHttpRequest;
import org.springframework.http.client.AsyncClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureAdapter;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.SuccessCallback;
import org.springframework.web.client.AsyncRequestCallback;
import org.springframework.web.client.AsyncRestTemplate;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class RetryRestTemplate
extends AsyncRestTemplate {
    static Logger log = LoggerFactory.getLogger(RetryRestTemplate.class);
    private int maxRetryTimes = 5;

    public RetryRestTemplate() {
    }

    public RetryRestTemplate(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public RetryRestTemplate(AsyncListenableTaskExecutor taskExecutor) {
        super(taskExecutor);
    }

    public RetryRestTemplate(AsyncClientHttpRequestFactory asyncRequestFactory) {
        super(asyncRequestFactory);
    }

    public RetryRestTemplate(AsyncClientHttpRequestFactory asyncRequestFactory, ClientHttpRequestFactory syncRequestFactory) {
        super(asyncRequestFactory, syncRequestFactory);
    }

    public RetryRestTemplate(AsyncClientHttpRequestFactory requestFactory, RestTemplate restTemplate) {
        super(requestFactory, restTemplate);
    }

    protected <T> ListenableFuture<T> doRawExecute(URI url, HttpMethod method, AsyncRequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        Assert.notNull((Object)url, (String)"'url' must not be null");
        Assert.notNull((Object)method, (String)"'method' must not be null");
        try {
            AsyncClientHttpRequest request = this.createAsyncRequest(url, method);
            if (requestCallback != null) {
                requestCallback.doWithRequest(request);
            }
            ListenableFuture responseFuture = request.executeAsync();
            return new RawResponseExtractorFuture<T>(method, url, (ListenableFuture<ClientHttpResponse>)responseFuture, responseExtractor);
        }
        catch (IOException ex) {
            throw new ResourceAccessException("I/O error on " + method.name() + " request for \"" + url + "\":" + ex.getMessage(), ex);
        }
    }

    protected <T> ListenableFuture<T> doExecute(URI url, HttpMethod method, AsyncRequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        ListenableFuture future = responseExtractor instanceof RawResponseExtractor ? this.doRawExecute(url, method, requestCallback, responseExtractor) : super.doExecute(url, method, requestCallback, responseExtractor);
        return new DelegateListenableFuture<T>(future, url, method, requestCallback, responseExtractor);
    }

    protected <T> ResponseExtractor<ResponseEntity<T>> responseEntityExtractor(Type responseType) {
        if (this.isRawResponseType(responseType)) {
            return new RawResponseExtractor(){

                public Object extractData(ClientHttpResponse response) throws IOException {
                    return new ResponseEntity((Object)response.getBody(), (MultiValueMap)response.getHeaders(), response.getStatusCode());
                }
            };
        }
        return super.responseEntityExtractor(responseType);
    }

    private boolean isRawResponseType(Type responseType) {
        return responseType instanceof Class && InputStream.class.isAssignableFrom((Class)responseType);
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    private void logResponseStatus(HttpMethod method, URI url, ClientHttpResponse response) {
        if (this.logger.isDebugEnabled()) {
            try {
                this.logger.debug((Object)("Async " + method.name() + " request for \"" + url + "\" resulted in " + response.getRawStatusCode() + " (" + response.getStatusText() + ")"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleResponseError(HttpMethod method, URI url, ClientHttpResponse response) throws IOException {
        if (this.logger.isWarnEnabled()) {
            try {
                this.logger.warn((Object)("Async " + method.name() + " request for \"" + url + "\" resulted in " + response.getRawStatusCode() + " (" + response.getStatusText() + "); invoking error handler"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.getErrorHandler().handleError(response);
    }

    private class RawResponseExtractorFuture<T>
    extends ListenableFutureAdapter<T, ClientHttpResponse> {
        private final HttpMethod method;
        private final URI url;
        private final ResponseExtractor<T> responseExtractor;

        public RawResponseExtractorFuture(HttpMethod method, URI url, ListenableFuture<ClientHttpResponse> clientHttpResponseFuture, ResponseExtractor<T> responseExtractor) {
            super(clientHttpResponseFuture);
            this.method = method;
            this.url = url;
            this.responseExtractor = responseExtractor;
        }

        protected final T adapt(ClientHttpResponse response) throws ExecutionException {
            try {
                if (!RetryRestTemplate.this.getErrorHandler().hasError(response)) {
                    RetryRestTemplate.this.logResponseStatus(this.method, this.url, response);
                } else {
                    RetryRestTemplate.this.handleResponseError(this.method, this.url, response);
                }
                return this.convertResponse(response);
            }
            catch (Throwable ex) {
                throw new ExecutionException(ex);
            }
        }

        protected T convertResponse(ClientHttpResponse response) throws IOException {
            return (T)(this.responseExtractor != null ? this.responseExtractor.extractData(response) : null);
        }
    }

    static interface RawResponseExtractor<T>
    extends ResponseExtractor<T> {
    }

    class DelegateListenableFuture<T>
    implements ListenableFuture<T> {
        private ListenableFuture<T> delegate;
        private URI url;
        private HttpMethod method;
        private AsyncRequestCallback requestCallback;
        private ResponseExtractor<T> responseExtractor;

        DelegateListenableFuture(ListenableFuture<T> delegate, URI url, HttpMethod method, AsyncRequestCallback requestCallback, ResponseExtractor<T> responseExtractor) {
            this.delegate = delegate;
            this.url = url;
            this.method = method;
            this.requestCallback = requestCallback;
            this.responseExtractor = responseExtractor;
        }

        public void addCallback(ListenableFutureCallback<? super T> callback) {
            this.delegate.addCallback(callback, new RetryFailureCallback<T>(this, this.url, this.method, this.requestCallback, this.responseExtractor, callback, (FailureCallback)callback));
        }

        public void addCallback(SuccessCallback<? super T> successCallback, FailureCallback failureCallback) {
            if (!(failureCallback instanceof RetryFailureCallback)) {
                failureCallback = new RetryFailureCallback<T>(this, this.url, this.method, this.requestCallback, this.responseExtractor, successCallback, failureCallback);
            }
            this.delegate.addCallback(successCallback, (FailureCallback)failureCallback);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.delegate.cancel(mayInterruptIfRunning);
        }

        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        public boolean isDone() {
            return this.delegate.isDone();
        }

        public T get() throws InterruptedException, ExecutionException {
            throw new IllegalStateException();
        }

        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new IllegalStateException();
        }

        private void setDelegate(ListenableFuture<T> delegate) {
            this.delegate = delegate;
        }
    }

    class RetryFailureCallback<T>
    implements FailureCallback {
        private DelegateListenableFuture<T> delegateFuture;
        private URI url;
        private HttpMethod method;
        private AsyncRequestCallback requestCallback;
        private ResponseExtractor<T> responseExtractor;
        private SuccessCallback<? super T> successCallback;
        private FailureCallback failureCallback;
        private int failureTimes;

        RetryFailureCallback(DelegateListenableFuture<T> delegateFuture, URI url, HttpMethod method, AsyncRequestCallback requestCallback, ResponseExtractor<T> responseExtractor, SuccessCallback<? super T> successCallback, FailureCallback failureCallback) {
            this.delegateFuture = delegateFuture;
            this.url = url;
            this.method = method;
            this.requestCallback = requestCallback;
            this.responseExtractor = responseExtractor;
            this.successCallback = successCallback;
            this.failureCallback = failureCallback;
            this.failureTimes = 0;
        }

        public void onFailure(Throwable ex) {
            if (ex instanceof ConnectException && this.failureTimes < RetryRestTemplate.this.maxRetryTimes) {
                log.info("\u91cd\u8bd5" + (this.failureTimes + 1) + "\u6b21 [" + this.method + ":" + this.url + "]");
                ListenableFuture<T> future = RetryRestTemplate.this.doExecute(this.url, this.method, this.requestCallback, this.responseExtractor);
                future.addCallback(this.successCallback, (FailureCallback)this);
                ((DelegateListenableFuture)this.delegateFuture).setDelegate(future);
            } else {
                this.failureCallback.onFailure(ex);
            }
            ++this.failureTimes;
        }
    }
}

