/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.util;

import cn.zhxu.toys.util.DigestUtils;
import cn.zhxu.toys.util.StringUtils;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class SignUtils {
    public static final String DEFAULT_SECRET_KEY = "secret";
    public static final String RSA = "RSA";
    public static final String SHA1WithRSA = "SHA1WithRSA";

    public static String genSign(Map<String, ?> params, String secretValue) {
        return SignUtils.doSign(params, DEFAULT_SECRET_KEY, secretValue);
    }

    public static String genSign(Map<String, ?> params, String secretKey, String secretValue) {
        return SignUtils.doSign(params, secretKey, secretValue);
    }

    public static String signWithoutKey(Map<String, ?> params, String secretValue) {
        return SignUtils.doSign(params, null, secretValue);
    }

    private static String doSign(Map<String, ?> params, String secretKey, String secretValue) {
        StringBuilder sb = new StringBuilder(SignUtils.serialize(params));
        if (secretKey != null) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(secretKey).append("=");
        }
        sb.append(secretValue);
        return DigestUtils.toMd5(sb.toString());
    }

    public static String serialize(Map<String, ?> params) {
        TreeMap map = params instanceof TreeMap ? params : new TreeMap(params);
        Set keys = map.keySet();
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            String valStr;
            Object value = map.get(key);
            if (value == null || !StringUtils.notBlank(valStr = value.toString())) continue;
            if (first) {
                first = false;
            } else {
                sb.append("&");
            }
            sb.append(key).append("=").append(valStr);
        }
        return sb.toString();
    }

    public static boolean verifyRsaSgin(String data, String publicKey, String sign) throws GeneralSecurityException {
        if (data == null) {
            return false;
        }
        return SignUtils.verifyRsaSgin(data.getBytes(StandardCharsets.UTF_8), publicKey, sign);
    }

    public static boolean verifyRsaSgin(byte[] data, String pubKey, String sign) throws GeneralSecurityException {
        byte[] keyBytes = Base64.getDecoder().decode(pubKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance(SHA1WithRSA);
        signature.initVerify(publicKey);
        signature.update(data);
        return signature.verify(Base64.getDecoder().decode(sign));
    }

    public static String signRsa(byte[] data, String pvtKey) throws GeneralSecurityException {
        byte[] keyBytes = Base64.getDecoder().decode(pvtKey);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        PrivateKey priKey = keyFactory.generatePrivate(keySpec);
        Signature signature = Signature.getInstance(SHA1WithRSA);
        signature.initSign(priKey);
        signature.update(data);
        byte[] signBytes = signature.sign();
        return new String(Base64.getEncoder().encode(signBytes));
    }
}

