/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.cipher;

import cn.zhxu.toys.cipher.Decryptor;
import cn.zhxu.toys.util.DigestUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;

public class ZLDecryptor
implements Decryptor {
    private String secret;

    @Override
    public void init(String secret) {
        this.secret = secret;
    }

    @Override
    public byte[] decrypt(byte[] cipherBytes) {
        return this.decrypt(this.secret.getBytes(StandardCharsets.UTF_8), cipherBytes);
    }

    @Override
    public byte[] decrypt(byte[] secretBytes, byte[] cipherBytes) {
        try {
            if (cipherBytes.length % 2 == 0) {
                throw new RuntimeException("\u4e0d\u53ef\u89e3\u6790\u7684\u5bc6\u6587\uff1a" + Arrays.toString(cipherBytes));
            }
            secretBytes = DigestUtils.toMd5(secretBytes);
            byte mod = cipherBytes[0];
            byte[] textBytes = new byte[(cipherBytes.length - 1) / 2];
            for (int i = 0; i < textBytes.length; ++i) {
                byte left = cipherBytes[2 * i + 1];
                byte right = cipherBytes[2 * i + 2];
                int sum = right * 2 + left - mod;
                byte secertByte = secretBytes[i % secretBytes.length];
                textBytes[i] = (byte)(sum - secertByte);
            }
            return textBytes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String decrypt(String cipherText) {
        return this.decrypt(this.secret, cipherText);
    }

    @Override
    public String decrypt(String secret, String cipherText) {
        byte[] cipherBytes = Base64.decodeBase64((String)cipherText);
        byte[] textBytes = this.decrypt(secret.getBytes(StandardCharsets.UTF_8), cipherBytes);
        return new String(textBytes, StandardCharsets.UTF_8);
    }
}

