/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.toys.captcha.impl;

import cn.zhxu.toys.captcha.CodeGenerator;
import java.util.Random;

public class RandomFormulaCodeGenerator
implements CodeGenerator {
    private static final String NUM_CHAR = "0123456789";
    private static final String OPERATORS = "+,-,*,\u00f7";
    private static final String ADDITION = "+";
    private static final String SUBTRACTION = "-";
    private static final String MULTIPLY = "*";
    private static final String DIVISION = "\u00f7";
    private static final String EQUAL_SIGN = "=";
    private final Random random = new Random();

    @Override
    public CodeGenerator.CodeResult generate() {
        String operator = this.getOperator();
        int[] nums = this.getNumber(operator);
        int resultNum = this.getResult(nums[0], nums[1], operator);
        String formula = nums[0] + operator + nums[1] + EQUAL_SIGN;
        String check = String.valueOf(resultNum);
        return new CodeGenerator.CodeResult(formula, check);
    }

    private int[] getNumber(String operator) {
        int[] numArray = new int[2];
        int firstNum = NUM_CHAR.charAt(this.random.nextInt(NUM_CHAR.length() - 1)) - 48;
        int secondNum = NUM_CHAR.charAt(this.random.nextInt(NUM_CHAR.length() - 1)) - 48;
        if (SUBTRACTION.equals(operator) || DIVISION.equals(operator)) {
            numArray[0] = Math.max(firstNum, secondNum);
            numArray[1] = Math.min(firstNum, secondNum);
            if (DIVISION.equals(operator)) {
                while (numArray[1] == 0 || numArray[0] % numArray[1] > 0) {
                    firstNum = NUM_CHAR.charAt(this.random.nextInt(NUM_CHAR.length() - 1)) - 48;
                    secondNum = NUM_CHAR.charAt(this.random.nextInt(NUM_CHAR.length() - 1)) - 48;
                    numArray[0] = Math.max(firstNum, secondNum);
                    numArray[1] = Math.min(firstNum, secondNum);
                }
            }
        } else {
            numArray[0] = firstNum;
            numArray[1] = secondNum;
        }
        return numArray;
    }

    private String getOperator() {
        String[] vcArray = OPERATORS.split(",");
        int iNum = this.random.nextInt(vcArray.length);
        return vcArray[iNum];
    }

    private int getResult(int firstNum, int secondNum, String operator) {
        int result = 0;
        switch (operator) {
            case "+": {
                result = firstNum + secondNum;
                break;
            }
            case "-": {
                result = firstNum - secondNum;
                break;
            }
            case "*": {
                result = firstNum * secondNum;
                break;
            }
            case "\u00f7": {
                result = firstNum / secondNum;
            }
        }
        return result;
    }
}

