/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.data.test;

import cn.zhxu.data.DataConvertor;
import cn.zhxu.data.test.School;
import cn.zhxu.data.test.Tests;
import cn.zhxu.data.test.TimeObject;
import cn.zhxu.data.test.User;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;

public class XmlTests
extends Tests {
    final String user1_0 = "<User><id>101001</id><name>Jack</name><school><id>101</id><name>\u6e05\u534e</name></school><deleted>false</deleted></User>";
    final String user2_0 = "<User><id>102002</id><name>Alice</name><school><id>102</id><name>\u5317\u5927</name></school><deleted>true</deleted></User>";

    public XmlTests(DataConvertor convertor) {
        super(convertor);
    }

    @Override
    protected Object[] objectsToSerialize() {
        return new Object[]{new TimeObject(LocalDateTime.parse("2025-08-08T12:34"))};
    }

    @Override
    protected String[][] stringsToDeserialize() {
        return new String[][]{{"<TimeObject><dateTime>2025-08-08 12:34</dateTime><date>2025-08-08</date><time>12:34</time></TimeObject>"}};
    }

    @Override
    String getStringForMapperValuesTest() {
        return "<User><id>1</id><age>20</age></User>";
    }

    @Override
    String getStringForArrayStreamTest() {
        return "<ArrayList><item>id</item><item>age</item><item>name</item></ArrayList>";
    }

    @Override
    protected String user1Str() {
        return "<User><id>101001</id><name>Jack</name><school><id>101</id><name>\u6e05\u534e</name></school><deleted>false</deleted></User>";
    }

    @Override
    protected boolean checkUser1Str(String xml) {
        return "<User><id>101001</id><name>Jack</name><school><id>101</id><name>\u6e05\u534e</name></school><deleted>false</deleted></User>".equals(xml);
    }

    @Override
    protected String user2Str() {
        return "<User><id>102002</id><name>Alice</name><school><id>102</id><name>\u5317\u5927</name></school><deleted>true</deleted></User>";
    }

    @Override
    protected boolean checkUser2Str(String xml) {
        return "<User><id>102002</id><name>Alice</name><school><id>102</id><name>\u5317\u5927</name></school><deleted>true</deleted></User>".equals(xml);
    }

    @Override
    protected String userListStr() {
        return "<ArrayList><item><id>101001</id><name>Jack</name><school><id>101</id><name>\u6e05\u534e</name></school><deleted>false</deleted></item><item><id>102002</id><name>Alice</name><school><id>102</id><name>\u5317\u5927</name></school><deleted>true</deleted></item></ArrayList>";
    }

    @Override
    protected boolean checkUserListStr(String xml) {
        return this.userListStr().equals(xml);
    }

    @Override
    protected String objectListStr() {
        return "<ArrayList><item><id>101001</id><name>Jack</name><school><id>101</id><name>\u6e05\u534e</name></school><deleted>false</deleted></item><item><id>102002</id><name>Alice</name><school><id>102</id><name>\u5317\u5927</name></school><deleted>true</deleted></item><item>Hello</item><item>100</item></ArrayList>";
    }

    @Override
    protected boolean checkObjectListStr(String xml) {
        return this.objectListStr().equals(xml);
    }

    @Override
    void assertSchool(Map<String, Object> school, School expected) {
        Assertions.assertFalse((boolean)school.isEmpty());
        Assertions.assertEquals((int)2, (int)school.size());
        Assertions.assertTrue((boolean)school.containsKey("id"));
        Assertions.assertTrue((boolean)school.containsKey("name"));
        Assertions.assertFalse((boolean)school.containsKey("address"));
        Assertions.assertEquals((Object)String.valueOf(expected.getId()), (Object)String.valueOf(school.get("id")));
        Assertions.assertEquals((Object)expected.getName(), (Object)school.get("name"));
    }

    @Override
    void assertUser(Map<String, Object> user, User expected) {
        Assertions.assertFalse((boolean)user.isEmpty());
        Assertions.assertEquals((int)4, (int)user.size());
        Assertions.assertTrue((boolean)user.containsKey("id"));
        Assertions.assertTrue((boolean)user.containsKey("name"));
        Assertions.assertTrue((boolean)user.containsKey("school"));
        Assertions.assertTrue((boolean)user.containsKey("deleted"));
        Assertions.assertFalse((boolean)user.containsKey("age"));
        Assertions.assertEquals((Object)String.valueOf(expected.getId()), (Object)String.valueOf(user.get("id")));
        Assertions.assertEquals((Object)expected.getName(), (Object)user.get("name"));
        Assertions.assertEquals((Object)String.valueOf(expected.isDeleted()), (Object)String.valueOf(user.get("deleted")));
        Map school = (Map)user.get("school");
        this.assertSchool(school, expected.getSchool());
    }

    @Override
    void assertObjectList(List<Object> array) {
        Assertions.assertFalse((boolean)array.isEmpty());
        Assertions.assertEquals((int)4, (int)array.size());
        this.assertUser((Map)array.get(0), (User)objectList.get(0));
        this.assertUser((Map)array.get(1), (User)objectList.get(1));
        Assertions.assertEquals((Object)array.get(2), objectList.get(2));
        Assertions.assertEquals((Object)String.valueOf(array.get(3)), (Object)String.valueOf(objectList.get(3)));
    }

    @Override
    protected boolean checkObjectListStr(String xml, boolean pretty) {
        if (pretty) {
            return "<ArrayList>\r\n  <item>\r\n    <id>101001</id>\r\n    <name>Jack</name>\r\n    <school>\r\n      <id>101</id>\r\n      <name>\u6e05\u534e</name>\r\n    </school>\r\n    <deleted>false</deleted>\r\n  </item>\r\n  <item>\r\n    <id>102002</id>\r\n    <name>Alice</name>\r\n    <school>\r\n      <id>102</id>\r\n      <name>\u5317\u5927</name>\r\n    </school>\r\n    <deleted>true</deleted>\r\n  </item>\r\n  <item>Hello</item>\r\n  <item>100</item>\r\n</ArrayList>\r\n".equals(xml);
        }
        return this.checkObjectListStr(xml);
    }

    @Override
    protected boolean checkUserListStr(String xml, boolean pretty) {
        if (pretty) {
            return "<ArrayList>\r\n  <item>\r\n    <id>101001</id>\r\n    <name>Jack</name>\r\n    <school>\r\n      <id>101</id>\r\n      <name>\u6e05\u534e</name>\r\n    </school>\r\n    <deleted>false</deleted>\r\n  </item>\r\n  <item>\r\n    <id>102002</id>\r\n    <name>Alice</name>\r\n    <school>\r\n      <id>102</id>\r\n      <name>\u5317\u5927</name>\r\n    </school>\r\n    <deleted>true</deleted>\r\n  </item>\r\n</ArrayList>\r\n".equals(xml);
        }
        return this.checkUserListStr(xml);
    }

    @Override
    protected boolean checkUser2Str(String xml, boolean pretty) {
        if (pretty) {
            return "<User>\r\n  <id>102002</id>\r\n  <name>Alice</name>\r\n  <school>\r\n    <id>102</id>\r\n    <name>\u5317\u5927</name>\r\n  </school>\r\n  <deleted>true</deleted>\r\n</User>\r\n".equals(xml);
        }
        return this.checkUser2Str(xml);
    }

    @Override
    protected boolean checkUser1Str(String xml, boolean pretty) {
        if (pretty) {
            return "<User>\r\n  <id>101001</id>\r\n  <name>Jack</name>\r\n  <school>\r\n    <id>101</id>\r\n    <name>\u6e05\u534e</name>\r\n  </school>\r\n  <deleted>false</deleted>\r\n</User>\r\n".equals(xml);
        }
        return this.checkUser1Str(xml);
    }
}

