/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.data.test;

import cn.zhxu.data.Array;
import cn.zhxu.data.DataConvertor;
import cn.zhxu.data.DataSet;
import cn.zhxu.data.Mapper;
import cn.zhxu.data.TypeRef;
import cn.zhxu.data.test.JsonTests;
import cn.zhxu.data.test.School;
import cn.zhxu.data.test.User;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;

public abstract class Tests {
    protected final DataConvertor convertor;
    protected static final User user1 = new User(101001, "Jack", new School(101, "\u6e05\u534e"), false);
    protected static final User user2 = new User(102002, "Alice", new School(102, "\u5317\u5927"), true);
    protected static final List<User> userList = new ArrayList<User>();
    protected static final List<Object> objectList = new ArrayList<Object>();

    public Tests(DataConvertor convertor) {
        this.convertor = convertor;
    }

    public void run() {
        this.run(true);
    }

    public void run(boolean runJdk8Time) {
        this.test_01_toMapper();
        this.test_02_toArray_01();
        this.test_03_toArray_02();
        this.test_04_toBean();
        this.test_05_toList();
        this.test_06_serialize();
        this.test_07_mapper_values();
        this.test_08_array_stream();
        if (runJdk8Time) {
            this.test_09_jdk8_times();
        }
    }

    private void test_09_jdk8_times() {
        Object[] objects = this.objectsToSerialize();
        String[][] strings = this.stringsToDeserialize();
        int length = Math.min(objects.length, strings.length);
        for (int i = 0; i < length; ++i) {
            Object object = objects[i];
            String[] expectValues = strings[i];
            this.assertContains(expectValues, this.convertor.serialize(object));
            for (String string : expectValues) {
                Assertions.assertEquals((Object)object, (Object)this.convertor.toBean(object.getClass(), string));
            }
        }
        System.out.println("case 09 passed!");
    }

    private void assertContains(String[] expectValues, String value) {
        for (String v : expectValues) {
            if (!Objects.equals(v, value)) continue;
            return;
        }
        Assertions.fail((String)("Not Contains: " + value + ", expectValues: " + Arrays.toString(expectValues)));
    }

    protected abstract Object[] objectsToSerialize();

    protected abstract String[][] stringsToDeserialize();

    protected abstract String user1Str();

    protected abstract boolean checkUser1Str(String var1);

    protected abstract boolean checkUser1Str(String var1, boolean var2);

    protected abstract String user2Str();

    protected abstract boolean checkUser2Str(String var1);

    protected abstract boolean checkUser2Str(String var1, boolean var2);

    protected abstract String userListStr();

    protected abstract boolean checkUserListStr(String var1);

    protected abstract boolean checkUserListStr(String var1, boolean var2);

    protected abstract String objectListStr();

    protected abstract boolean checkObjectListStr(String var1);

    protected abstract boolean checkObjectListStr(String var1, boolean var2);

    void assertUser(Mapper user, User expected) {
        Assertions.assertFalse((boolean)user.isEmpty());
        Assertions.assertEquals((int)4, (int)user.size());
        Assertions.assertTrue((boolean)user.has("id"));
        Assertions.assertTrue((boolean)user.has("name"));
        Assertions.assertTrue((boolean)user.has("school"));
        Assertions.assertTrue((boolean)user.has("deleted"));
        Assertions.assertFalse((boolean)user.has("age"));
        Set keySet = user.keySet();
        Assertions.assertEquals((int)4, (int)keySet.size());
        Assertions.assertTrue((boolean)keySet.contains("id"));
        Assertions.assertTrue((boolean)keySet.contains("name"));
        Assertions.assertTrue((boolean)keySet.contains("school"));
        Assertions.assertTrue((boolean)keySet.contains("deleted"));
        Assertions.assertEquals((int)expected.getId(), (int)user.getInt("id"));
        Assertions.assertEquals((Object)expected.getName(), (Object)user.getString("name"));
        Assertions.assertEquals((Object)expected.isDeleted(), (Object)user.getBool("deleted"));
        Assertions.assertEquals((Object)user.toBean(User.class), (Object)expected);
        this.assertSchool(user.getMapper("school"), expected.getSchool());
        this.assertUser(user.toMap(), expected);
        User uu = new User();
        AtomicInteger count = new AtomicInteger(0);
        user.forEach((key, data) -> {
            if ("id".equals(key)) {
                uu.setId(data.toInt());
            }
            if ("name".equals(key)) {
                uu.setName(data.toString());
            }
            if ("school".equals(key)) {
                uu.setSchool((School)data.toMapper().toBean(School.class));
            }
            if ("deleted".equals(key)) {
                uu.setDeleted(data.toBool());
            }
            count.getAndIncrement();
        });
        Assertions.assertEquals((Object)uu, (Object)expected);
        Assertions.assertEquals((int)4, (int)count.intValue());
    }

    void assertUser(Map<String, Object> user, User expected) {
        Assertions.assertFalse((boolean)user.isEmpty());
        Assertions.assertEquals((int)4, (int)user.size());
        Assertions.assertTrue((boolean)user.containsKey("id"));
        Assertions.assertTrue((boolean)user.containsKey("name"));
        Assertions.assertTrue((boolean)user.containsKey("school"));
        Assertions.assertTrue((boolean)user.containsKey("deleted"));
        Assertions.assertFalse((boolean)user.containsKey("age"));
        Assertions.assertEquals((Object)String.valueOf(expected.getId()), (Object)String.valueOf(user.get("id")));
        Assertions.assertEquals((Object)expected.getName(), (Object)user.get("name"));
        Assertions.assertEquals((Object)expected.isDeleted(), (Object)user.get("deleted"));
        Map school = (Map)user.get("school");
        this.assertSchool(school, expected.getSchool());
    }

    void assertSchool(Mapper school, School expected) {
        Assertions.assertFalse((boolean)school.isEmpty());
        Assertions.assertEquals((int)2, (int)school.size());
        Assertions.assertTrue((boolean)school.has("id"));
        Assertions.assertTrue((boolean)school.has("name"));
        Assertions.assertFalse((boolean)school.has("address"));
        Assertions.assertEquals((int)expected.getId(), (int)school.getInt("id"));
        Assertions.assertEquals((Object)expected.getName(), (Object)school.getString("name"));
        Assertions.assertEquals((Object)expected, (Object)school.toBean(School.class));
        this.assertSchool(school.toMap(), expected);
    }

    void assertSchool(Map<String, Object> school, School expected) {
        Assertions.assertFalse((boolean)school.isEmpty());
        Assertions.assertEquals((int)2, (int)school.size());
        Assertions.assertTrue((boolean)school.containsKey("id"));
        Assertions.assertTrue((boolean)school.containsKey("name"));
        Assertions.assertFalse((boolean)school.containsKey("address"));
        Assertions.assertEquals((Object)String.valueOf(expected.getId()), (Object)String.valueOf(school.get("id")));
        Assertions.assertEquals((Object)expected.getName(), (Object)school.get("name"));
    }

    void assertObjectList(Array array) {
        Assertions.assertFalse((boolean)array.isEmpty());
        Assertions.assertEquals((int)4, (int)array.size());
        this.assertUser(array.getMapper(0), user1);
        this.assertUser(array.getMapper(1), user2);
        Assertions.assertEquals((Object)"Hello", (Object)array.getString(2));
        Assertions.assertEquals((int)100, (int)array.getInt(3));
        ArrayList<Object> list = new ArrayList<Object>();
        AtomicInteger count = new AtomicInteger(0);
        array.forEach((index, data) -> {
            if (index == 0) {
                this.assertUser(data.toMapper(), user1);
                list.add(data.toMapper().toMap());
            }
            if (index == 1) {
                this.assertUser(data.toMapper(), user2);
                list.add(data.toMapper().toMap());
            }
            if (index == 2) {
                Assertions.assertEquals((Object)data.toString(), (Object)"Hello");
                list.add(data.toString());
            }
            if (index == 3) {
                Assertions.assertEquals((int)data.toInt(), (int)100);
                list.add(data.toInt());
            }
            count.incrementAndGet();
        });
        Assertions.assertEquals((int)4, (int)count.intValue());
        this.assertObjectList(list);
        this.assertObjectList(array.toList());
    }

    void assertUserList(Array array) {
        Assertions.assertFalse((boolean)array.isEmpty());
        Assertions.assertEquals((int)2, (int)array.size());
        this.assertUser(array.getMapper(0), user1);
        this.assertUser(array.getMapper(1), user2);
        this.assertUserList(array.toList(User.class));
    }

    void assertUserList(List<User> array) {
        Assertions.assertArrayEquals((Object[])userList.toArray(), (Object[])array.toArray());
    }

    void assertObjectList(List<Object> array) {
        Assertions.assertFalse((boolean)array.isEmpty());
        Assertions.assertEquals((int)4, (int)array.size());
        this.assertUser((Map)array.get(0), (User)objectList.get(0));
        this.assertUser((Map)array.get(1), (User)objectList.get(1));
        Assertions.assertEquals((Object)array.get(2), (Object)objectList.get(2));
        Assertions.assertEquals((Object)String.valueOf(array.get(3)), (Object)String.valueOf(objectList.get(3)));
    }

    protected void test_01_toMapper() {
        Mapper mapper1 = this.doMapperTest(this.user1Str(), user1);
        if (this instanceof JsonTests) {
            this.doMapperTest(mapper1.toString(), user1);
            this.doMapperTest(mapper1.toPretty(), user1);
            Assertions.assertTrue((boolean)this.checkUser1Str(mapper1.toString()));
            Assertions.assertTrue((boolean)this.checkUser1Str(mapper1.toPretty(), true));
        }
        Mapper mapper2 = this.doMapperTest(this.user2Str(), user2);
        if (this instanceof JsonTests) {
            this.doMapperTest(mapper2.toString(), user2);
            this.doMapperTest(mapper2.toPretty(), user2);
            Assertions.assertTrue((boolean)this.checkUser2Str(mapper2.toString()));
            Assertions.assertTrue((boolean)this.checkUser2Str(mapper2.toPretty(), true));
        }
        System.out.println("case 01 passed!");
    }

    protected Mapper doMapperTest(String input, User user1) {
        Mapper mapper = this.convertor.toMapper(input);
        this.assertUser(mapper, user1);
        ByteArrayInputStream in1 = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));
        this.assertUser(this.convertor.toMapper((InputStream)in1, StandardCharsets.UTF_8), user1);
        return mapper;
    }

    protected void test_02_toArray_01() {
        ByteArrayInputStream in = new ByteArrayInputStream(this.userListStr().getBytes(StandardCharsets.UTF_8));
        this.assertUserList(this.convertor.toArray((InputStream)in, StandardCharsets.UTF_8));
        Array array = this.convertor.toArray(this.userListStr());
        this.assertUserList(array);
        if (this instanceof JsonTests) {
            this.assertUserList(this.convertor.toArray(array.toString()));
            this.assertUserList(this.convertor.toArray(array.toPretty()));
        }
        System.out.println("case 02 passed!");
    }

    protected void test_03_toArray_02() {
        ByteArrayInputStream in = new ByteArrayInputStream(this.objectListStr().getBytes(StandardCharsets.UTF_8));
        this.assertObjectList(this.convertor.toArray((InputStream)in, StandardCharsets.UTF_8));
        Array array = this.convertor.toArray(this.objectListStr());
        this.assertObjectList(array);
        if (this instanceof JsonTests) {
            this.assertObjectList(this.convertor.toArray(array.toString()));
            this.assertObjectList(this.convertor.toArray(array.toPretty()));
        }
        System.out.println("case 03 passed!");
    }

    protected void test_04_toBean() {
        Assertions.assertEquals((Object)user1, (Object)this.convertor.toBean(User.class, this.user1Str()));
        Assertions.assertEquals((Object)user2, (Object)this.convertor.toBean(User.class, this.user2Str()));
        ByteArrayInputStream in1 = new ByteArrayInputStream(this.user1Str().getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)user1, (Object)this.convertor.toBean(User.class, (InputStream)in1, StandardCharsets.UTF_8));
        ByteArrayInputStream in2 = new ByteArrayInputStream(this.user2Str().getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)user2, (Object)this.convertor.toBean(User.class, (InputStream)in2, StandardCharsets.UTF_8));
        List list = (List)this.convertor.toBean(new TypeRef<List<User>>(){}.getType(), this.userListStr());
        this.assertUserList(list);
        System.out.println("case 04 passed!");
    }

    protected void test_05_toList() {
        this.assertUserList(this.convertor.toList(User.class, this.userListStr()));
        ByteArrayInputStream in = new ByteArrayInputStream(this.userListStr().getBytes(StandardCharsets.UTF_8));
        this.assertUserList(this.convertor.toList(User.class, (InputStream)in, StandardCharsets.UTF_8));
        System.out.println("case 05 passed!");
    }

    protected void test_06_serialize() {
        Assertions.assertTrue((boolean)this.checkUser1Str(this.convertor.serialize((Object)user1)));
        Assertions.assertTrue((boolean)this.checkUser2Str(this.convertor.serialize((Object)user2)));
        Assertions.assertTrue((boolean)this.checkUserListStr(this.convertor.serialize(userList)));
        Assertions.assertTrue((boolean)this.checkObjectListStr(this.convertor.serialize(objectList)));
        Assertions.assertTrue((boolean)this.checkUser1Str(this.convertor.serialize((Object)user1, true), true));
        Assertions.assertTrue((boolean)this.checkUser2Str(this.convertor.serialize((Object)user2, true), true));
        Assertions.assertTrue((boolean)this.checkUserListStr(this.convertor.serialize(userList, true), true));
        Assertions.assertTrue((boolean)this.checkObjectListStr(this.convertor.serialize(objectList, true), true));
        Assertions.assertTrue((boolean)this.checkUser1Str(this.convertor.serialize((Object)user1, false), false));
        Assertions.assertTrue((boolean)this.checkUser2Str(this.convertor.serialize((Object)user2, false), false));
        Assertions.assertTrue((boolean)this.checkUserListStr(this.convertor.serialize(userList, false), false));
        Assertions.assertTrue((boolean)this.checkObjectListStr(this.convertor.serialize(objectList, false), false));
        Assertions.assertTrue((boolean)this.checkUser1Str(new String(this.convertor.serialize((Object)user1, StandardCharsets.UTF_8))));
        Assertions.assertTrue((boolean)this.checkUser2Str(new String(this.convertor.serialize((Object)user2, StandardCharsets.UTF_8))));
        Assertions.assertTrue((boolean)this.checkUserListStr(new String(this.convertor.serialize(userList, StandardCharsets.UTF_8))));
        Assertions.assertTrue((boolean)this.checkObjectListStr(new String(this.convertor.serialize(objectList, StandardCharsets.UTF_8))));
        Assertions.assertTrue((boolean)this.checkUser1Str(new String(this.convertor.serialize((Object)user1, StandardCharsets.UTF_8, true)), true));
        Assertions.assertTrue((boolean)this.checkUser2Str(new String(this.convertor.serialize((Object)user2, StandardCharsets.UTF_8, true)), true));
        Assertions.assertTrue((boolean)this.checkUserListStr(new String(this.convertor.serialize(userList, StandardCharsets.UTF_8, true)), true));
        Assertions.assertTrue((boolean)this.checkObjectListStr(new String(this.convertor.serialize(objectList, StandardCharsets.UTF_8, true)), true));
        Assertions.assertTrue((boolean)this.checkUser1Str(new String(this.convertor.serialize((Object)user1, StandardCharsets.UTF_8, false)), false));
        Assertions.assertTrue((boolean)this.checkUser2Str(new String(this.convertor.serialize((Object)user2, StandardCharsets.UTF_8, false)), false));
        Assertions.assertTrue((boolean)this.checkUserListStr(new String(this.convertor.serialize(userList, StandardCharsets.UTF_8, false)), false));
        Assertions.assertTrue((boolean)this.checkObjectListStr(new String(this.convertor.serialize(objectList, StandardCharsets.UTF_8, false)), false));
        System.out.println("case 06 passed!");
    }

    abstract String getStringForMapperValuesTest();

    private void test_07_mapper_values() {
        Set values = this.convertor.toMapper(this.getStringForMapperValuesTest()).values().stream().map(DataSet.Data::toInt).collect(Collectors.toSet());
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(1);
        set.add(20);
        Assertions.assertEquals(values, set);
        System.out.println("case 07 passed!");
    }

    abstract String getStringForArrayStreamTest();

    private void test_08_array_stream() {
        Array array = this.convertor.toArray(this.getStringForArrayStreamTest());
        List values = array.stream().map(DataSet.Data::toString).collect(Collectors.toList());
        ArrayList<String> list = new ArrayList<String>();
        list.add("id");
        list.add("age");
        list.add("name");
        Assertions.assertEquals(values, list);
        int idx = 0;
        for (DataSet.Data data : array) {
            Assertions.assertEquals(list.get(idx++), (Object)data.toString());
        }
        Assertions.assertEquals((int)list.size(), (int)idx);
        Iterator it = array.iterator();
        idx = 0;
        while (it.hasNext()) {
            Assertions.assertEquals(list.get(idx++), (Object)((DataSet.Data)it.next()).toString());
        }
        Assertions.assertEquals((int)list.size(), (int)idx);
        System.out.println("case 08 passed!");
    }

    static {
        userList.add(user1);
        userList.add(user2);
        objectList.add(user1);
        objectList.add(user2);
        objectList.add("Hello");
        objectList.add(100);
    }
}

