/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.data.test;

import cn.zhxu.data.DataConvertor;
import cn.zhxu.data.test.Tests;
import cn.zhxu.data.test.TimeObject;
import java.time.LocalDateTime;

public class JsonTests
extends Tests {
    final String user1_0 = "{\"id\":101001,\"name\":\"Jack\",\"school\":{\"id\":101,\"name\":\"\u6e05\u534e\"},\"deleted\":false}";
    final String user1_1 = "{\"deleted\":false,\"id\":101001,\"name\":\"Jack\",\"school\":{\"id\":101,\"name\":\"\u6e05\u534e\"}}";
    final String user1_2 = "{\"deleted\":false,\"school\":{\"name\":\"\u6e05\u534e\",\"id\":101},\"name\":\"Jack\",\"id\":101001}";
    final String user1_0_pretty = "{\n\t\"id\":101001,\n\t\"name\":\"Jack\",\n\t\"school\":{\n\t\t\"id\":101,\n\t\t\"name\":\"\u6e05\u534e\"\n\t},\n\t\"deleted\":false\n}";
    final String user1_1_pretty = "{\n\t\"deleted\":false,\n\t\"id\":101001,\n\t\"name\":\"Jack\",\n\t\"school\":{\n\t\t\"id\":101,\n\t\t\"name\":\"\u6e05\u534e\"\n\t}\n}";
    final String user1_2_pretty = "{\n\t\"deleted\":false,\n\t\"school\":{\n\t\t\"name\":\"\u6e05\u534e\",\n\t\t\"id\":101\n\t},\n\t\"name\":\"Jack\",\n\t\"id\":101001\n}";
    final String user2_0 = "{\"id\":102002,\"name\":\"Alice\",\"school\":{\"id\":102,\"name\":\"\u5317\u5927\"},\"deleted\":true}";
    final String user2_1 = "{\"deleted\":true,\"id\":102002,\"name\":\"Alice\",\"school\":{\"id\":102,\"name\":\"\u5317\u5927\"}}";
    final String user2_2 = "{\"deleted\":true,\"school\":{\"name\":\"\u5317\u5927\",\"id\":102},\"name\":\"Alice\",\"id\":102002}";
    final String user2_0_pretty = "{\n\t\"id\":102002,\n\t\"name\":\"Alice\",\n\t\"school\":{\n\t\t\"id\":102,\n\t\t\"name\":\"\u5317\u5927\"\n\t},\n\t\"deleted\":true\n}";
    final String user2_1_pretty = "{\n\t\"deleted\":true,\n\t\"id\":102002,\n\t\"name\":\"Alice\",\n\t\"school\":{\n\t\t\"id\":102,\n\t\t\"name\":\"\u5317\u5927\"\n\t}\n}";
    final String user2_2_pretty = "{\n\t\"deleted\":true,\n\t\"school\":{\n\t\t\"name\":\"\u5317\u5927\",\n\t\t\"id\":102\n\t},\n\t\"name\":\"Alice\",\n\t\"id\":102002\n}";

    public JsonTests(DataConvertor convertor) {
        super(convertor);
    }

    @Override
    protected Object[] objectsToSerialize() {
        return new Object[]{new TimeObject(LocalDateTime.parse("2025-08-08T12:34"))};
    }

    @Override
    protected String[][] stringsToDeserialize() {
        return new String[][]{{"{\"dateTime\":\"2025-08-08 12:34\",\"date\":\"2025-08-08\",\"time\":\"12:34\"}", "{\"date\":\"2025-08-08\",\"dateTime\":\"2025-08-08 12:34\",\"time\":\"12:34\"}"}};
    }

    @Override
    protected String user1Str() {
        return "{\"id\":101001,\"name\":\"Jack\",\"school\":{\"id\":101,\"name\":\"\u6e05\u534e\"},\"deleted\":false}";
    }

    @Override
    protected boolean checkUser1Str(String json) {
        return "{\"id\":101001,\"name\":\"Jack\",\"school\":{\"id\":101,\"name\":\"\u6e05\u534e\"},\"deleted\":false}".equals(json) || "{\"deleted\":false,\"id\":101001,\"name\":\"Jack\",\"school\":{\"id\":101,\"name\":\"\u6e05\u534e\"}}".equals(json) || "{\"deleted\":false,\"school\":{\"name\":\"\u6e05\u534e\",\"id\":101},\"name\":\"Jack\",\"id\":101001}".equals(json);
    }

    @Override
    protected String user2Str() {
        return "{\"id\":102002,\"name\":\"Alice\",\"school\":{\"id\":102,\"name\":\"\u5317\u5927\"},\"deleted\":true}";
    }

    @Override
    protected boolean checkUser2Str(String json) {
        return "{\"id\":102002,\"name\":\"Alice\",\"school\":{\"id\":102,\"name\":\"\u5317\u5927\"},\"deleted\":true}".equals(json) || "{\"deleted\":true,\"id\":102002,\"name\":\"Alice\",\"school\":{\"id\":102,\"name\":\"\u5317\u5927\"}}".equals(json) || "{\"deleted\":true,\"school\":{\"name\":\"\u5317\u5927\",\"id\":102},\"name\":\"Alice\",\"id\":102002}".equals(json);
    }

    @Override
    protected String userListStr() {
        return "[{\"id\":101001,\"name\":\"Jack\",\"school\":{\"id\":101,\"name\":\"\u6e05\u534e\"},\"deleted\":false},{\"id\":102002,\"name\":\"Alice\",\"school\":{\"id\":102,\"name\":\"\u5317\u5927\"},\"deleted\":true}]";
    }

    @Override
    protected boolean checkUserListStr(String json) {
        return this.userListStr().equals(json) || "[{\"deleted\":false,\"id\":101001,\"name\":\"Jack\",\"school\":{\"id\":101,\"name\":\"\u6e05\u534e\"}},{\"deleted\":true,\"id\":102002,\"name\":\"Alice\",\"school\":{\"id\":102,\"name\":\"\u5317\u5927\"}}]".equals(json) || "[{\"deleted\":false,\"school\":{\"name\":\"\u6e05\u534e\",\"id\":101},\"name\":\"Jack\",\"id\":101001},{\"deleted\":true,\"school\":{\"name\":\"\u5317\u5927\",\"id\":102},\"name\":\"Alice\",\"id\":102002}]".equals(json);
    }

    @Override
    protected String objectListStr() {
        return "[{\"id\":101001,\"name\":\"Jack\",\"school\":{\"id\":101,\"name\":\"\u6e05\u534e\"},\"deleted\":false},{\"id\":102002,\"name\":\"Alice\",\"school\":{\"id\":102,\"name\":\"\u5317\u5927\"},\"deleted\":true},\"Hello\",100]";
    }

    @Override
    protected boolean checkObjectListStr(String json) {
        return this.objectListStr().equals(json) || "[{\"deleted\":false,\"id\":101001,\"name\":\"Jack\",\"school\":{\"id\":101,\"name\":\"\u6e05\u534e\"}},{\"deleted\":true,\"id\":102002,\"name\":\"Alice\",\"school\":{\"id\":102,\"name\":\"\u5317\u5927\"}},\"Hello\",100]".equals(json) || "[{\"deleted\":false,\"school\":{\"name\":\"\u6e05\u534e\",\"id\":101},\"name\":\"Jack\",\"id\":101001},{\"deleted\":true,\"school\":{\"name\":\"\u5317\u5927\",\"id\":102},\"name\":\"Alice\",\"id\":102002},\"Hello\",100]".equals(json);
    }

    @Override
    protected boolean checkUser1Str(String json, boolean pretty) {
        if (pretty) {
            return this.prettyJsonEquals("{\n\t\"id\":101001,\n\t\"name\":\"Jack\",\n\t\"school\":{\n\t\t\"id\":101,\n\t\t\"name\":\"\u6e05\u534e\"\n\t},\n\t\"deleted\":false\n}", json) || this.prettyJsonEquals("{\n\t\"deleted\":false,\n\t\"id\":101001,\n\t\"name\":\"Jack\",\n\t\"school\":{\n\t\t\"id\":101,\n\t\t\"name\":\"\u6e05\u534e\"\n\t}\n}", json) || this.prettyJsonEquals("{\n\t\"deleted\":false,\n\t\"school\":{\n\t\t\"name\":\"\u6e05\u534e\",\n\t\t\"id\":101\n\t},\n\t\"name\":\"Jack\",\n\t\"id\":101001\n}", json);
        }
        return this.checkUser1Str(json);
    }

    @Override
    protected boolean checkUser2Str(String json, boolean pretty) {
        if (pretty) {
            return this.prettyJsonEquals("{\n\t\"id\":102002,\n\t\"name\":\"Alice\",\n\t\"school\":{\n\t\t\"id\":102,\n\t\t\"name\":\"\u5317\u5927\"\n\t},\n\t\"deleted\":true\n}", json) || this.prettyJsonEquals("{\n\t\"deleted\":true,\n\t\"id\":102002,\n\t\"name\":\"Alice\",\n\t\"school\":{\n\t\t\"id\":102,\n\t\t\"name\":\"\u5317\u5927\"\n\t}\n}", json) || this.prettyJsonEquals("{\n\t\"deleted\":true,\n\t\"school\":{\n\t\t\"name\":\"\u5317\u5927\",\n\t\t\"id\":102\n\t},\n\t\"name\":\"Alice\",\n\t\"id\":102002\n}", json);
        }
        return this.checkUser2Str(json);
    }

    @Override
    protected boolean checkUserListStr(String json, boolean pretty) {
        if (pretty) {
            return this.prettyJsonEquals("[\n\t" + "{\n\t\"id\":101001,\n\t\"name\":\"Jack\",\n\t\"school\":{\n\t\t\"id\":101,\n\t\t\"name\":\"\u6e05\u534e\"\n\t},\n\t\"deleted\":false\n}".replace("\n", "\n\t") + ",\n\t" + "{\n\t\"id\":102002,\n\t\"name\":\"Alice\",\n\t\"school\":{\n\t\t\"id\":102,\n\t\t\"name\":\"\u5317\u5927\"\n\t},\n\t\"deleted\":true\n}".replace("\n", "\n\t") + "\n]", json) || this.prettyJsonEquals("[\n\t" + "{\n\t\"deleted\":false,\n\t\"id\":101001,\n\t\"name\":\"Jack\",\n\t\"school\":{\n\t\t\"id\":101,\n\t\t\"name\":\"\u6e05\u534e\"\n\t}\n}".replace("\n", "\n\t") + ",\n\t" + "{\n\t\"deleted\":true,\n\t\"id\":102002,\n\t\"name\":\"Alice\",\n\t\"school\":{\n\t\t\"id\":102,\n\t\t\"name\":\"\u5317\u5927\"\n\t}\n}".replace("\n", "\n\t") + "\n]", json) || this.prettyJsonEquals("[\n\t" + "{\n\t\"deleted\":false,\n\t\"school\":{\n\t\t\"name\":\"\u6e05\u534e\",\n\t\t\"id\":101\n\t},\n\t\"name\":\"Jack\",\n\t\"id\":101001\n}".replace("\n", "\n\t") + ",\n\t" + "{\n\t\"deleted\":true,\n\t\"school\":{\n\t\t\"name\":\"\u5317\u5927\",\n\t\t\"id\":102\n\t},\n\t\"name\":\"Alice\",\n\t\"id\":102002\n}".replace("\n", "\n\t") + "\n]", json) || this.prettyJsonEquals("[ {\n\t\"id\":101001,\n\t\"name\":\"Jack\",\n\t\"school\":{\n\t\t\"id\":101,\n\t\t\"name\":\"\u6e05\u534e\"\n\t},\n\t\"deleted\":false\n}, {\n\t\"id\":102002,\n\t\"name\":\"Alice\",\n\t\"school\":{\n\t\t\"id\":102,\n\t\t\"name\":\"\u5317\u5927\"\n\t},\n\t\"deleted\":true\n} ]", json) || this.prettyJsonEquals("[ {\n\t\"deleted\":false,\n\t\"id\":101001,\n\t\"name\":\"Jack\",\n\t\"school\":{\n\t\t\"id\":101,\n\t\t\"name\":\"\u6e05\u534e\"\n\t}\n}, {\n\t\"deleted\":true,\n\t\"id\":102002,\n\t\"name\":\"Alice\",\n\t\"school\":{\n\t\t\"id\":102,\n\t\t\"name\":\"\u5317\u5927\"\n\t}\n} ]", json) || this.prettyJsonEquals("[ {\n\t\"deleted\":false,\n\t\"school\":{\n\t\t\"name\":\"\u6e05\u534e\",\n\t\t\"id\":101\n\t},\n\t\"name\":\"Jack\",\n\t\"id\":101001\n}, {\n\t\"deleted\":true,\n\t\"school\":{\n\t\t\"name\":\"\u5317\u5927\",\n\t\t\"id\":102\n\t},\n\t\"name\":\"Alice\",\n\t\"id\":102002\n} ]", json);
        }
        return this.checkUserListStr(json);
    }

    @Override
    protected boolean checkObjectListStr(String json, boolean pretty) {
        if (pretty) {
            return this.prettyJsonEquals("[\n\t" + "{\n\t\"id\":101001,\n\t\"name\":\"Jack\",\n\t\"school\":{\n\t\t\"id\":101,\n\t\t\"name\":\"\u6e05\u534e\"\n\t},\n\t\"deleted\":false\n}".replace("\n", "\n\t") + ",\n\t" + "{\n\t\"id\":102002,\n\t\"name\":\"Alice\",\n\t\"school\":{\n\t\t\"id\":102,\n\t\t\"name\":\"\u5317\u5927\"\n\t},\n\t\"deleted\":true\n}".replace("\n", "\n\t") + ",\n\t\"Hello\",\n\t100\n]", json) || this.prettyJsonEquals("[\n\t" + "{\n\t\"deleted\":false,\n\t\"id\":101001,\n\t\"name\":\"Jack\",\n\t\"school\":{\n\t\t\"id\":101,\n\t\t\"name\":\"\u6e05\u534e\"\n\t}\n}".replace("\n", "\n\t") + ",\n\t" + "{\n\t\"deleted\":true,\n\t\"id\":102002,\n\t\"name\":\"Alice\",\n\t\"school\":{\n\t\t\"id\":102,\n\t\t\"name\":\"\u5317\u5927\"\n\t}\n}".replace("\n", "\n\t") + ",\n\t\"Hello\",\n\t100\n]", json) || this.prettyJsonEquals("[\n\t" + "{\n\t\"deleted\":false,\n\t\"school\":{\n\t\t\"name\":\"\u6e05\u534e\",\n\t\t\"id\":101\n\t},\n\t\"name\":\"Jack\",\n\t\"id\":101001\n}".replace("\n", "\n\t") + ",\n\t" + "{\n\t\"deleted\":true,\n\t\"school\":{\n\t\t\"name\":\"\u5317\u5927\",\n\t\t\"id\":102\n\t},\n\t\"name\":\"Alice\",\n\t\"id\":102002\n}".replace("\n", "\n\t") + ",\n\t\"Hello\",\n\t100\n]", json) || this.prettyJsonEquals("[ {\n\t\"id\":101001,\n\t\"name\":\"Jack\",\n\t\"school\":{\n\t\t\"id\":101,\n\t\t\"name\":\"\u6e05\u534e\"\n\t},\n\t\"deleted\":false\n}, {\n\t\"id\":102002,\n\t\"name\":\"Alice\",\n\t\"school\":{\n\t\t\"id\":102,\n\t\t\"name\":\"\u5317\u5927\"\n\t},\n\t\"deleted\":true\n}, \"Hello\", 100 ]", json) || this.prettyJsonEquals("[ {\n\t\"deleted\":false,\n\t\"id\":101001,\n\t\"name\":\"Jack\",\n\t\"school\":{\n\t\t\"id\":101,\n\t\t\"name\":\"\u6e05\u534e\"\n\t}\n}, {\n\t\"deleted\":true,\n\t\"id\":102002,\n\t\"name\":\"Alice\",\n\t\"school\":{\n\t\t\"id\":102,\n\t\t\"name\":\"\u5317\u5927\"\n\t}\n}, \"Hello\", 100 ]", json) || this.prettyJsonEquals("[ {\n\t\"deleted\":false,\n\t\"school\":{\n\t\t\"name\":\"\u6e05\u534e\",\n\t\t\"id\":101\n\t},\n\t\"name\":\"Jack\",\n\t\"id\":101001\n}, {\n\t\"deleted\":true,\n\t\"school\":{\n\t\t\"name\":\"\u5317\u5927\",\n\t\t\"id\":102\n\t},\n\t\"name\":\"Alice\",\n\t\"id\":102002\n}, \"Hello\", 100 ]", json);
        }
        return this.checkObjectListStr(json);
    }

    @Override
    String getStringForMapperValuesTest() {
        return "{\"id\":1,\"age\":20}";
    }

    @Override
    String getStringForArrayStreamTest() {
        return "[\"id\",\"age\",\"name\"]";
    }

    private boolean prettyJsonEquals(String expect, String json) {
        return expect.equals(json) || expect.replace("\t", "  ").equals(json) || expect.replace(":", ": ").equals(json) || expect.replace(":", " : ").equals(json) || expect.replace("\t", "  ").replace(":", ": ").equals(json) || expect.replace("\t", "  ").replace(":", " : ").equals(json) || expect.replace("\n", "\r\n").equals(json) || expect.replace("\n", "\r\n").replace("\t", "  ").equals(json) || expect.replace("\n", "\r\n").replace(":", ": ").equals(json) || expect.replace("\n", "\r\n").replace(":", " : ").equals(json) || expect.replace("\n", "\r\n").replace("\t", "  ").replace(":", ": ").equals(json) || expect.replace("\n", "\r\n").replace("\t", "  ").replace(":", " : ").equals(json);
    }
}

